/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rmi.RmiComponent;
import org.apache.camel.component.rmi.RmiConsumer;
import org.apache.camel.component.rmi.RmiProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="1.0.0", scheme="rmi", title="RMI", syntax="rmi:hostname:port/name", label="messaging")
public class RmiEndpoint
extends DefaultEndpoint {
    private ClassLoader classLoader;
    private URI uri;
    @UriPath(description="Hostname of RMI server", defaultValue="localhost")
    private String hostname;
    @UriPath(description="Port number of RMI server", defaultValue="1099")
    private int port;
    @UriPath(description="Name to use when binding to RMI server")
    @Metadata(required=true)
    private String name;
    @UriParam
    private List<Class<?>> remoteInterfaces;
    @UriParam
    private String method;

    public RmiEndpoint() {
    }

    protected RmiEndpoint(String endpointUri, RmiComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.uri = new URI(endpointUri);
    }

    public boolean isSingleton() {
        return false;
    }

    protected String createEndpointUri() {
        return this.uri.toString();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.uri, (String)"uri");
        if (this.remoteInterfaces == null || this.remoteInterfaces.size() == 0) {
            throw new IllegalArgumentException("To create a RMI consumer, the RMI endpoint's remoteInterfaces property must be be configured.");
        }
        RmiConsumer answer = new RmiConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.uri, (String)"uri");
        return new RmiProducer(this);
    }

    public String getName() {
        String path = this.uri.getPath();
        if (path == null) {
            path = this.uri.getSchemeSpecificPart();
        }
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public Registry getRegistry() throws RemoteException {
        if (this.uri.getHost() != null) {
            if (this.uri.getPort() == -1) {
                return LocateRegistry.getRegistry(this.uri.getHost());
            }
            return LocateRegistry.getRegistry(this.uri.getHost(), this.uri.getPort());
        }
        return LocateRegistry.getRegistry();
    }

    public List<Class<?>> getRemoteInterfaces() {
        return this.remoteInterfaces;
    }

    public void setRemoteInterfaces(List<Class<?>> remoteInterfaces) {
        this.remoteInterfaces = remoteInterfaces;
        if (this.classLoader == null && !remoteInterfaces.isEmpty()) {
            this.classLoader = remoteInterfaces.get(0).getClassLoader();
        }
    }

    public void setRemoteInterfaces(Class<?> ... remoteInterfaces) {
        this.setRemoteInterfaces(Arrays.asList(remoteInterfaces));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

