/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.parser.model.RestConfigurationDetails;
import org.apache.camel.parser.model.RestServiceDetails;
import org.apache.camel.parser.model.RestVerbDetails;
import org.apache.camel.parser.roaster.StatementFieldSource;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.InfixExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NumberLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class CamelJavaRestDslParserHelper {
    public List<RestConfigurationDetails> parseRestConfiguration(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, MethodSource<JavaClassSource> configureMethod) {
        MethodDeclaration md;
        Block block;
        ArrayList<RestConfigurationDetails> answer = new ArrayList<RestConfigurationDetails>();
        if (configureMethod != null && (block = (md = (MethodDeclaration)configureMethod.getInternal()).getBody()) != null) {
            for (Object statement : md.getBody().statements()) {
                ExpressionStatement es;
                Expression exp;
                boolean valid;
                if (!(statement instanceof ExpressionStatement) || !(valid = this.isRestConfiguration(exp = (es = (ExpressionStatement)statement).getExpression()))) continue;
                RestConfigurationDetails node = new RestConfigurationDetails();
                answer.add(node);
                int pos = exp.getStartPosition();
                int line = CamelJavaRestDslParserHelper.findLineNumber(fullyQualifiedFileName, pos);
                if (line > -1) {
                    node.setLineNumber("" + line);
                }
                if ((line = CamelJavaRestDslParserHelper.findLineNumber(fullyQualifiedFileName, pos = exp.getStartPosition() + exp.getLength())) > -1) {
                    node.setLineNumberEnd("" + line);
                }
                node.setFileName(fullyQualifiedFileName);
                node.setClassName(clazz.getQualifiedName());
                node.setMethodName(configureMethod.getName());
                this.parseExpression(node, fullyQualifiedFileName, clazz, configureMethod, block, exp);
            }
        }
        return answer;
    }

    public List<RestServiceDetails> parseRestService(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, MethodSource<JavaClassSource> configureMethod) {
        MethodDeclaration md;
        Block block;
        ArrayList<RestServiceDetails> answer = new ArrayList<RestServiceDetails>();
        if (configureMethod != null && (block = (md = (MethodDeclaration)configureMethod.getInternal()).getBody()) != null) {
            for (Object statement : md.getBody().statements()) {
                ExpressionStatement es;
                Expression exp;
                boolean valid;
                if (!(statement instanceof ExpressionStatement) || !(valid = this.isRest(exp = (es = (ExpressionStatement)statement).getExpression()))) continue;
                RestServiceDetails node = new RestServiceDetails();
                answer.add(node);
                int pos = exp.getStartPosition();
                int line = CamelJavaRestDslParserHelper.findLineNumber(fullyQualifiedFileName, pos);
                if (line > -1) {
                    node.setLineNumber("" + line);
                }
                if ((line = CamelJavaRestDslParserHelper.findLineNumber(fullyQualifiedFileName, pos = exp.getStartPosition() + exp.getLength())) > -1) {
                    node.setLineNumberEnd("" + line);
                }
                node.setFileName(fullyQualifiedFileName);
                node.setClassName(clazz.getQualifiedName());
                node.setMethodName(configureMethod.getName());
                this.parseExpression(node, null, fullyQualifiedFileName, clazz, configureMethod, block, exp);
                if (node.getVerbs() == null) continue;
                Collections.reverse(node.getVerbs());
            }
        }
        return answer;
    }

    private boolean isRestConfiguration(Expression exp) {
        Expression parent;
        String rootMethodName = null;
        Expression sub = exp;
        while (sub instanceof MethodInvocation && (!((sub = ((MethodInvocation)sub).getExpression()) instanceof MethodInvocation) || (parent = ((MethodInvocation)sub).getExpression()) != null)) {
        }
        if (sub instanceof MethodInvocation) {
            rootMethodName = ((MethodInvocation)sub).getName().getIdentifier();
        } else if (sub instanceof SimpleName) {
            rootMethodName = ((SimpleName)sub).getIdentifier();
        }
        return "restConfiguration".equals(rootMethodName);
    }

    private boolean isRest(Expression exp) {
        Expression parent;
        String rootMethodName = null;
        Expression sub = exp;
        while (sub instanceof MethodInvocation && (!((sub = ((MethodInvocation)sub).getExpression()) instanceof MethodInvocation) || (parent = ((MethodInvocation)sub).getExpression()) != null)) {
        }
        if (sub instanceof MethodInvocation) {
            rootMethodName = ((MethodInvocation)sub).getName().getIdentifier();
        } else if (sub instanceof SimpleName) {
            rootMethodName = ((SimpleName)sub).getIdentifier();
        }
        return "rest".equals(rootMethodName);
    }

    private void parseExpression(RestConfigurationDetails node, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, Expression exp) {
        if (exp == null) {
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            this.doParseRestConfiguration(node, fullyQualifiedFileName, clazz, configureMethod, block, mi);
            exp = mi.getExpression();
            this.parseExpression(node, fullyQualifiedFileName, clazz, configureMethod, block, exp);
        }
    }

    private void parseExpression(RestServiceDetails node, RestVerbDetails verb, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, Expression exp) {
        if (exp == null) {
            if (verb != null) {
                node.setConsumes(verb.getConsumes());
                node.setProduces(verb.getProduces());
                node.setSkipBindingOnErrorCode(verb.getSkipBindingOnErrorCode());
                node.setClientRequestValidation(verb.getClientRequestValidation());
                node.setApiDocs(verb.getApiDocs());
                node.setDescription(verb.getDescription());
            }
            return;
        }
        if (exp instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)exp;
            verb = this.doParseRestService(node, verb, fullyQualifiedFileName, clazz, configureMethod, block, mi);
            exp = mi.getExpression();
            this.parseExpression(node, verb, fullyQualifiedFileName, clazz, configureMethod, block, exp);
        }
    }

    private void doParseRestConfiguration(RestConfigurationDetails node, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, MethodInvocation mi) {
        String name;
        int pos;
        int line;
        if (node.getLineNumberEnd() == null && (line = CamelJavaRestDslParserHelper.findLineNumber(fullyQualifiedFileName, pos = mi.getStartPosition() + mi.getLength())) > -1) {
            node.setLineNumberEnd("" + line);
        }
        if ("component".equals(name = mi.getName().getIdentifier())) {
            node.setComponent(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiComponent".equals(name)) {
            node.setApiComponent(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("producerComponent".equals(name)) {
            node.setProducerComponent(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("scheme".equals(name)) {
            node.setScheme(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("host".equals(name)) {
            node.setHost(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiHost".equals(name)) {
            node.setApiHost(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("port".equals(name)) {
            node.setPort(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("producerApiDoc".equals(name)) {
            node.setProducerApiDoc(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("contextPath".equals(name)) {
            node.setContextPath(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiContextPath".equals(name)) {
            node.setApiContextPath(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiContextRouteId".equals(name)) {
            node.setApiContextRouteId(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiContextIdPattern".equals(name)) {
            node.setApiContextIdPattern(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiContextListening".equals(name)) {
            node.setApiContextListening(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiVendorExtension".equals(name)) {
            node.setApiVendorExtension(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("hostNameResolver".equals(name)) {
            node.setHostNameResolver(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("bindingMode".equals(name)) {
            node.setBindingMode(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("skipBindingOnErrorCode".equals(name)) {
            node.setSkipBindingOnErrorCode(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("clientRequestValidation".equals(name)) {
            node.setClientRequestValidation(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("enableCORS".equals(name)) {
            node.setEnableCORS(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("jsonDataFormat".equals(name)) {
            node.setJsonDataFormat(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("xmlDataFormat".equals(name)) {
            node.setXmlDataFormat(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("componentProperty".equals(name)) {
            String key = CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi);
            String value = CamelJavaRestDslParserHelper.extractValueFromSecondArgument(clazz, block, mi);
            node.addComponentProperty(key, value);
        } else if ("endpointProperty".equals(name)) {
            String key = CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi);
            String value = CamelJavaRestDslParserHelper.extractValueFromSecondArgument(clazz, block, mi);
            node.addEndpointProperty(key, value);
        } else if ("consumerProperty".equals(name)) {
            String key = CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi);
            String value = CamelJavaRestDslParserHelper.extractValueFromSecondArgument(clazz, block, mi);
            node.addConsumerProperty(key, value);
        } else if ("dataFormatProperty".equals(name)) {
            String key = CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi);
            String value = CamelJavaRestDslParserHelper.extractValueFromSecondArgument(clazz, block, mi);
            node.addDataFormatProperty(key, value);
        } else if ("apiProperty".equals(name)) {
            String key = CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi);
            String value = CamelJavaRestDslParserHelper.extractValueFromSecondArgument(clazz, block, mi);
            node.addApiProperty(key, value);
        } else if ("corsHeaderProperty".equals(name)) {
            String key = CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi);
            String value = CamelJavaRestDslParserHelper.extractValueFromSecondArgument(clazz, block, mi);
            node.addCorsHeader(key, value);
        }
    }

    private RestVerbDetails doParseRestService(RestServiceDetails node, RestVerbDetails verb, String fullyQualifiedFileName, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, MethodInvocation mi) {
        String name;
        int pos;
        int line;
        if (node.getLineNumberEnd() == null && (line = CamelJavaRestDslParserHelper.findLineNumber(fullyQualifiedFileName, pos = mi.getStartPosition() + mi.getLength())) > -1) {
            node.setLineNumberEnd("" + line);
        }
        if ("rest".equals(name = mi.getName().getIdentifier())) {
            node.setPath(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if (CamelJavaRestDslParserHelper.isParentMethod(mi, "rest")) {
            verb = this.doParseRestVerb(node, verb, clazz, configureMethod, block, mi);
        }
        return verb;
    }

    private RestVerbDetails doParseRestVerb(RestServiceDetails node, RestVerbDetails verb, JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, Block block, MethodInvocation mi) {
        String name;
        if (verb == null) {
            verb = new RestVerbDetails();
        }
        if ("description".equals(name = mi.getName().getIdentifier())) {
            verb.setDescription(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("bindingMode".equals(name)) {
            verb.setBindingMode(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("skipBindingOnErrorCode".equals(name)) {
            verb.setSkipBindingOnErrorCode(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("clientRequestValidation".equals(name)) {
            verb.setClientRequestValidation(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("consumes".equals(name)) {
            verb.setConsumes(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("produces".equals(name)) {
            verb.setProduces(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("type".equals(name)) {
            verb.setType(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("outType".equals(name)) {
            verb.setOutType(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("apiDocs".equals(name)) {
            verb.setApiDocs(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("to".equals(name)) {
            verb.setTo(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("toD".equals(name)) {
            verb.setToD(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        } else if ("tag".equals(name)) {
            node.setTag(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
        }
        if ("delete".equals(name)) {
            node.addVerb(verb);
            verb.setMethod("delete");
            verb.setUri(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
            verb = null;
        } else if ("get".equals(name)) {
            node.addVerb(verb);
            verb.setMethod("get");
            verb.setUri(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
            verb = null;
        } else if ("head".equals(name)) {
            node.addVerb(verb);
            verb.setMethod("head");
            verb.setUri(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
            verb = null;
        } else if ("patch".equals(name)) {
            node.addVerb(verb);
            verb.setMethod("patch");
            verb.setUri(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
            verb = null;
        } else if ("post".equals(name)) {
            node.addVerb(verb);
            verb.setMethod("post");
            verb.setUri(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
            verb = null;
        } else if ("put".equals(name)) {
            node.addVerb(verb);
            verb.setMethod("put");
            verb.setUri(CamelJavaRestDslParserHelper.extractValueFromFirstArgument(clazz, block, mi));
            verb = null;
        }
        return verb;
    }

    private static boolean isParentMethod(MethodInvocation mi, String parentName) {
        String name = mi.getName().getIdentifier();
        if (parentName.equals(name)) {
            return true;
        }
        MethodInvocation sub = mi;
        while (sub instanceof MethodInvocation) {
            if (!((sub = sub.getExpression()) instanceof MethodInvocation) || !parentName.equals(name = sub.getName().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private static String extractValueFromFirstArgument(JavaClassSource clazz, Block block, MethodInvocation mi) {
        List args = mi.arguments();
        if (args != null && !args.isEmpty()) {
            Expression exp = (Expression)args.get(0);
            return CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, exp);
        }
        return null;
    }

    private static String extractValueFromSecondArgument(JavaClassSource clazz, Block block, MethodInvocation mi) {
        List args = mi.arguments();
        if (args != null && args.size() > 1) {
            Expression exp = (Expression)args.get(1);
            return CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, exp);
        }
        return null;
    }

    private static FieldSource<JavaClassSource> getField(JavaClassSource clazz, Block block, SimpleName ref) {
        String fieldName = ref.getIdentifier();
        if (fieldName != null) {
            FieldSource<JavaClassSource> field;
            FieldSource<JavaClassSource> fieldSource = field = clazz != null ? clazz.getField(fieldName) : null;
            if (field == null) {
                field = CamelJavaRestDslParserHelper.findFieldInBlock(clazz, block, fieldName);
            }
            return field;
        }
        return null;
    }

    private static FieldSource<JavaClassSource> findFieldInBlock(JavaClassSource clazz, Block block, String fieldName) {
        for (Object statement : block.statements()) {
            ASTNode node;
            if (statement instanceof VariableDeclarationStatement) {
                Type type = ((VariableDeclarationStatement)statement).getType();
                for (Object obj : ((VariableDeclarationStatement)statement).fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource(clazz, fragment, type);
                }
            }
            if ((node = block.getParent()) instanceof MethodDeclaration) {
                node = node.getParent();
            }
            if (!(node instanceof AnonymousClassDeclaration)) continue;
            List declarations = ((AnonymousClassDeclaration)node).bodyDeclarations();
            for (Object dec : declarations) {
                if (!(dec instanceof FieldDeclaration)) continue;
                FieldDeclaration fd = (FieldDeclaration)dec;
                Type type = fd.getType();
                for (Object obj : fd.fragments()) {
                    VariableDeclarationFragment fragment;
                    SimpleName name;
                    if (!(obj instanceof VariableDeclarationFragment) || (name = (fragment = (VariableDeclarationFragment)obj).getName()) == null || !fieldName.equals(name.getIdentifier())) continue;
                    return new StatementFieldSource(clazz, fragment, type);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLiteralValue(JavaClassSource clazz, Block block, Expression expression) {
        boolean numeric;
        if (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            return "" + ((BooleanLiteral)expression).booleanValue();
        }
        if (expression instanceof NumberLiteral) {
            return ((NumberLiteral)expression).getToken();
        }
        if (expression instanceof MethodInvocation) {
            String name = ((MethodInvocation)expression).getName().getIdentifier();
            return "{{" + name + "}}";
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)expression;
            return qn.getName().getIdentifier();
        }
        if (expression instanceof SimpleName) {
            FieldSource<JavaClassSource> field = CamelJavaRestDslParserHelper.getField(clazz, block, (SimpleName)expression);
            if (field != null) {
                VariableDeclarationFragment vdf;
                if (field.getAnnotations() != null) {
                    for (Annotation ann : field.getAnnotations()) {
                        boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                        if (!valid) continue;
                        Expression exp = (Expression)ann.getInternal();
                        if (exp instanceof SingleMemberAnnotation) {
                            exp = ((SingleMemberAnnotation)exp).getValue();
                        } else if (exp instanceof NormalAnnotation) {
                            List values = ((NormalAnnotation)exp).values();
                            for (Object value : values) {
                                MemberValuePair pair = (MemberValuePair)value;
                                if (!"uri".equals(pair.getName().toString())) continue;
                                exp = pair.getValue();
                                break;
                            }
                        }
                        if (exp == null) continue;
                        return CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, exp);
                    }
                }
                if ("Endpoint".equals(field.getType().getSimpleName())) {
                    vdf = (VariableDeclarationFragment)field.getInternal();
                    expression = vdf.getInitializer();
                    if (!(expression instanceof MethodInvocation)) return null;
                    MethodInvocation mi = (MethodInvocation)expression;
                    List args = mi.arguments();
                    if (args == null) return null;
                    if (args.isEmpty()) return null;
                    expression = (Expression)args.get(0);
                    return CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, expression);
                }
                vdf = (VariableDeclarationFragment)field.getInternal();
                expression = vdf.getInitializer();
                if (expression != null) return CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, expression);
                return "{{" + field.getName() + "}}";
            }
            String fieldName = ((SimpleName)expression).getIdentifier();
            return "{{" + fieldName + "}}";
        }
        if (!(expression instanceof InfixExpression)) return null;
        String answer = null;
        InfixExpression ie = (InfixExpression)expression;
        if (!InfixExpression.Operator.PLUS.equals(ie.getOperator())) return answer;
        String val1 = CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, ie.getLeftOperand());
        String val2 = CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, ie.getRightOperand());
        boolean bl = numeric = CamelJavaRestDslParserHelper.isNumericOperator(clazz, block, ie.getLeftOperand()) && CamelJavaRestDslParserHelper.isNumericOperator(clazz, block, ie.getRightOperand());
        if (numeric) {
            long num1 = val1 != null ? Long.parseLong(val1) : 0L;
            long num2 = val2 != null ? Long.parseLong(val2) : 0L;
            answer = Long.toString(num1 + num2);
        } else {
            answer = (val1 != null ? val1 : "") + (val2 != null ? val2 : "");
        }
        if (answer.isEmpty()) return answer;
        List extended = ie.extendedOperands();
        if (extended == null) return answer;
        StringBuilder answerBuilder = new StringBuilder(answer);
        Iterator iterator = extended.iterator();
        while (iterator.hasNext()) {
            Object ext = iterator.next();
            String val3 = CamelJavaRestDslParserHelper.getLiteralValue(clazz, block, (Expression)ext);
            if (numeric) {
                long num3 = val3 != null ? Long.parseLong(val3) : 0L;
                long num = Long.parseLong(answerBuilder.toString());
                answerBuilder = new StringBuilder(Long.toString(num + num3));
                continue;
            }
            answerBuilder.append(val3 != null ? val3 : "");
        }
        return answerBuilder.toString();
    }

    private static boolean isNumericOperator(JavaClassSource clazz, Block block, Expression expression) {
        FieldSource<JavaClassSource> field;
        if (expression instanceof NumberLiteral) {
            return true;
        }
        if (expression instanceof SimpleName && (field = CamelJavaRestDslParserHelper.getField(clazz, block, (SimpleName)expression)) != null) {
            return field.getType().isType("int") || field.getType().isType("long") || field.getType().isType("Integer") || field.getType().isType("Long");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLineNumber(String fullyQualifiedFileName, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new FileReader(fullyQualifiedFileName));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int n = lines;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }
}

