/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.rss;

import java.util.ArrayList;
import java.util.List;

import com.sun.syndication.feed.synd.SyndFeed;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggregateRssFeedStrategy implements AggregationStrategy {
    protected final transient Log log = LogFactory.getLog(AggregateRssFeedStrategy.class);    
    
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        SyndFeed oldFeed = oldExchange.getIn().getBody(SyndFeed.class);
        SyndFeed newFeed = newExchange.getIn().getBody(SyndFeed.class);
        if (oldFeed != null && newFeed != null) {                
            List oldEntries = oldFeed.getEntries();                  
            List newEntries = newFeed.getEntries();
            List mergedList = new ArrayList(oldEntries.size() + newEntries.size());
            mergedList.addAll(oldEntries);
            mergedList.addAll(newEntries);
            oldFeed.setEntries(mergedList);    
        } else {
            log.debug("Could not merge exchanges. One body was null.");
        }
        return oldExchange;
    }
}