/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.codegen;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.utils.SecurityUtils;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.client.PubSubApiClient;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.DigestAuthentication;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;

public abstract class AbstractSalesforceExecution {
    private static final int DEFAULT_TIMEOUT = 60000;
    String clientId;
    String clientSecret;
    Map<String, Object> httpClientProperties;
    String httpProxyAuthUri;
    Set<String> httpProxyExcludedAddresses;
    String httpProxyHost;
    Set<String> httpProxyIncludedAddresses;
    String httpProxyPassword;
    Integer httpProxyPort;
    String httpProxyRealm;
    boolean httpProxyUseDigestAuth;
    String httpProxyUsername;
    boolean isHttpProxySecure = true;
    boolean isHttpProxySocks4;
    String loginUrl;
    String password;
    SSLContextParameters sslContextParameters;
    String userName;
    String version;
    private long responseTimeout;
    private SalesforceHttpClient httpClient;
    private SalesforceSession session;
    private RestClient restClient;
    private PubSubApiClient pubSubApiClient;
    private String pubSubHost;
    private int pubSubPort;

    public final void execute() throws Exception {
        this.setup();
        this.login();
        try {
            this.executeWithClient();
        }
        finally {
            this.disconnectFromSalesforce(this.restClient);
        }
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    private void login() {
        try {
            this.httpClient = this.createHttpClient();
            this.getLog().info("Logging in to Salesforce");
            this.session = this.httpClient.getSession();
            try {
                this.session.login(null);
            }
            catch (SalesforceException e) {
                String msg = "Salesforce login error " + e.getMessage();
                throw new RuntimeException(msg, e);
            }
            this.getLog().info("Salesforce login successful");
        }
        catch (Exception e) {
            String msg = "Error connecting to Salesforce: " + e.getMessage();
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.session, this.httpClient});
            throw new RuntimeException(msg, e);
        }
    }

    protected RestClient getRestClient() {
        if (this.restClient != null) {
            return this.restClient;
        }
        try {
            this.login();
            this.restClient = new DefaultRestClient(this.httpClient, this.version, this.session, new SalesforceLoginConfig());
            ((DefaultRestClient)this.restClient).start();
            return this.restClient;
        }
        catch (Exception e) {
            String msg = "Error connecting to Salesforce: " + e.getMessage();
            this.disconnectFromSalesforce(this.restClient);
            throw new RuntimeException(msg, e);
        }
    }

    protected PubSubApiClient getPubSubApiClient() {
        if (this.pubSubApiClient != null) {
            return this.pubSubApiClient;
        }
        this.pubSubApiClient = new PubSubApiClient(this.session, new SalesforceLoginConfig(), this.pubSubHost, this.pubSubPort, 0L, 0L);
        this.pubSubApiClient.start();
        return this.pubSubApiClient;
    }

    private SalesforceHttpClient createHttpClient() throws Exception {
        SalesforceHttpClient httpClient;
        DefaultCamelContext camelContext = new DefaultCamelContext();
        try {
            SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setSslContext(this.sslContextParameters.createSSLContext((CamelContext)camelContext));
            SecurityUtils.adaptToIBMCipherNames((SslContextFactory)sslContextFactory);
            httpClient = new SalesforceHttpClient(sslContextFactory);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Error creating default SSL context: " + e.getMessage(), e);
        }
        httpClient.setConnectTimeout(60000L);
        httpClient.setTimeout(60000L);
        httpClient.setFollowRedirects(true);
        if (this.httpClientProperties != null && !this.httpClientProperties.isEmpty()) {
            try {
                PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)httpClient, new HashMap<String, Object>(this.httpClientProperties));
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting HTTP client properties: " + e.getMessage(), e);
            }
        }
        this.responseTimeout = httpClient.getTimeout() + 1000L;
        if (this.httpProxyHost != null && this.httpProxyPort != null) {
            Origin.Address proxyAddress = new Origin.Address(this.httpProxyHost, this.httpProxyPort.intValue());
            Object proxy = this.isHttpProxySocks4 ? new Socks4Proxy(proxyAddress, this.isHttpProxySecure) : new HttpProxy(proxyAddress, this.isHttpProxySecure);
            if (this.httpProxyIncludedAddresses != null && !this.httpProxyIncludedAddresses.isEmpty()) {
                proxy.getIncludedAddresses().addAll(this.httpProxyIncludedAddresses);
            }
            if (this.httpProxyExcludedAddresses != null && !this.httpProxyExcludedAddresses.isEmpty()) {
                proxy.getExcludedAddresses().addAll(this.httpProxyExcludedAddresses);
            }
            httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)proxy);
        }
        if (this.httpProxyUsername != null && this.httpProxyPassword != null) {
            StringHelper.notEmpty((String)this.httpProxyAuthUri, (String)"httpProxyAuthUri");
            StringHelper.notEmpty((String)this.httpProxyRealm, (String)"httpProxyRealm");
            Object authentication = this.httpProxyUseDigestAuth ? new DigestAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword) : new BasicAuthentication(URI.create(this.httpProxyAuthUri), this.httpProxyRealm, this.httpProxyUsername, this.httpProxyPassword);
            httpClient.getAuthenticationStore().addAuthentication((Authentication)authentication);
        }
        SalesforceSession session = new SalesforceSession((CamelContext)new DefaultCamelContext(), httpClient, httpClient.getTimeout(), new SalesforceLoginConfig(this.loginUrl, this.clientId, this.clientSecret, this.userName, this.password, false));
        httpClient.setSession(session);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating HTTP client: " + e.getMessage(), e);
        }
        return httpClient;
    }

    private void disconnectFromSalesforce(RestClient restClient) {
        if (restClient == null) {
            return;
        }
        try {
            SalesforceHttpClient httpClient = (SalesforceHttpClient)((DefaultRestClient)restClient).getHttpClient();
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{restClient, httpClient.getSession(), httpClient});
        }
        catch (Exception e) {
            this.getLog().error("Error stopping Salesforce HTTP client", (Throwable)e);
        }
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setHttpClientProperties(Map<String, Object> httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    public void setHttpProxyAuthUri(String httpProxyAuthUri) {
        this.httpProxyAuthUri = httpProxyAuthUri;
    }

    public void setHttpProxyExcludedAddresses(Set<String> httpProxyExcludedAddresses) {
        this.httpProxyExcludedAddresses = httpProxyExcludedAddresses;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyIncludedAddresses(Set<String> httpProxyIncludedAddresses) {
        this.httpProxyIncludedAddresses = httpProxyIncludedAddresses;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyRealm(String httpProxyRealm) {
        this.httpProxyRealm = httpProxyRealm;
    }

    public void setHttpProxyUseDigestAuth(boolean httpProxyUseDigestAuth) {
        this.httpProxyUseDigestAuth = httpProxyUseDigestAuth;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxySecure(boolean httpProxySecure) {
        this.isHttpProxySecure = httpProxySecure;
    }

    public void setHttpProxySocks4(boolean httpProxySocks4) {
        this.isHttpProxySocks4 = httpProxySocks4;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPubSubHost(String pubSubHost) {
        this.pubSubHost = pubSubHost;
    }

    public void setPubSubPort(int pubSubPort) {
        this.pubSubPort = pubSubPort;
    }

    protected abstract void executeWithClient() throws Exception;

    protected abstract Logger getLog();

    public void setup() {
    }
}

