/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.NoSuchOptionException;
import org.apache.camel.component.extension.verifier.OptionsGroup;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.SalesforceClientTemplate;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;

public class SalesforceComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    SalesforceComponentVerifierExtension() {
        super("salesforce");
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).errors(ResultErrorHelper.requiresAny(parameters, (OptionsGroup[])new OptionsGroup[]{OptionsGroup.withName((Enum)AuthenticationType.USERNAME_PASSWORD).options(new String[]{"clientId", "clientSecret", "userName", "password", "!refreshToken", "!keystore"}), OptionsGroup.withName((Enum)AuthenticationType.REFRESH_TOKEN).options(new String[]{"clientId", "clientSecret", "refreshToken", "!password", "!keystore"}), OptionsGroup.withName((Enum)AuthenticationType.JWT).options(new String[]{"clientId", "userName", "keystore", "!password", "!refreshToken"})}));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            SalesforceClientTemplate.invoke(this.getCamelContext(), parameters, client -> {
                client.getVersions(Collections.emptyMap(), (response, headers, exception) -> SalesforceComponentVerifierExtension.processSalesforceException(builder, Optional.ofNullable(exception)));
                return null;
            });
        }
        catch (NoSuchOptionException e) {
            builder.error(ResultErrorBuilder.withMissingOption((String)e.getOptionName()).build());
        }
        catch (Exception e) {
            if (e.getCause() instanceof SalesforceException) {
                SalesforceComponentVerifierExtension.processSalesforceException(builder, Optional.of((SalesforceException)((Object)e.getCause())));
            }
            builder.error(ResultErrorBuilder.withException((Exception)e).build());
        }
        return builder.build();
    }

    private static void processSalesforceException(ResultBuilder builder, Optional<SalesforceException> exception) {
        exception.ifPresent(e -> {
            builder.error(ResultErrorBuilder.withException((Exception)((Object)e)).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_CODE, (Object)e.getStatusCode()).build());
            for (RestError error : e.getErrors()) {
                builder.error(ResultErrorBuilder.withCode((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.GENERIC).description(error.getMessage()).parameterKeys(error.getFields()).detail("salesforce_code", (Object)error.getErrorCode()).build());
            }
        });
    }
}

