/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.DeleteSObjectResult;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.SaveSObjectResult;
import org.apache.camel.component.salesforce.api.dto.UpsertSObjectResult;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectCollection;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.CompositeSObjectCollectionsApiClient;
import org.apache.camel.component.salesforce.internal.dto.composite.RetrieveSObjectCollectionsDto;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;

public class DefaultCompositeSObjectCollectionsApiClient
extends AbstractClientBase
implements CompositeSObjectCollectionsApiClient {
    private final ObjectMapper mapper;

    public DefaultCompositeSObjectCollectionsApiClient(SalesforceEndpointConfig configuration, String version, SalesforceSession session, SalesforceHttpClient httpClient, SalesforceLoginConfig loginConfig) throws SalesforceException {
        super(version, session, httpClient, loginConfig);
        this.mapper = configuration.getObjectMapper() != null ? configuration.getObjectMapper() : JsonUtils.createObjectMapper();
    }

    @Override
    public <T> void submitRetrieveCompositeCollections(RetrieveSObjectCollectionsDto retrieveDto, Map<String, List<String>> headers, final CompositeSObjectCollectionsApiClient.ResponseCallback<List<T>> callback, String sObjectName, final Class<T> sobjectType) throws SalesforceException {
        String url = this.versionUrl() + "composite/sobjects/" + sObjectName;
        Request request = this.createRequest("POST", url, headers);
        ContentProvider content = this.serialize(retrieveDto, new Class[0]);
        request.content(content);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                Optional<Object> body = Optional.empty();
                if (ex == null) {
                    body = DefaultCompositeSObjectCollectionsApiClient.this.tryToReadListResponse(sobjectType, response);
                }
                callback.onResponse(body, headers, ex);
            }
        });
    }

    @Override
    public void createCompositeCollections(SObjectCollection collection, Map<String, List<String>> headers, CompositeSObjectCollectionsApiClient.ResponseCallback<List<SaveSObjectResult>> callback) throws SalesforceException {
        this.createUpdateCompositeCollections(collection, headers, callback, "POST");
    }

    @Override
    public void updateCompositeCollections(SObjectCollection collection, Map<String, List<String>> headers, CompositeSObjectCollectionsApiClient.ResponseCallback<List<SaveSObjectResult>> callback) throws SalesforceException {
        this.createUpdateCompositeCollections(collection, headers, callback, "PATCH");
    }

    private void createUpdateCompositeCollections(SObjectCollection collection, Map<String, List<String>> headers, final CompositeSObjectCollectionsApiClient.ResponseCallback<List<SaveSObjectResult>> callback, String method) throws SalesforceException {
        String url = this.versionUrl() + "composite/sobjects";
        Request request = this.createRequest(method, url, headers);
        ContentProvider content = this.serialize(collection, new Class[0]);
        request.content(content);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                Optional<Object> body = Optional.empty();
                if (ex == null) {
                    body = DefaultCompositeSObjectCollectionsApiClient.this.tryToReadListResponse(SaveSObjectResult.class, response);
                }
                callback.onResponse(body, headers, ex);
            }
        });
    }

    @Override
    public void upsertCompositeCollections(SObjectCollection collection, Map<String, List<String>> headers, final CompositeSObjectCollectionsApiClient.ResponseCallback<List<UpsertSObjectResult>> callback, String sObjectName, String externalIdFieldName) throws SalesforceException {
        String url = this.versionUrl() + "composite/sobjects";
        url = url + "/" + sObjectName;
        if (externalIdFieldName != null) {
            url = url + "/" + externalIdFieldName;
        }
        Request request = this.createRequest("PATCH", url, headers);
        ContentProvider content = this.serialize(collection, new Class[0]);
        request.content(content);
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                Optional<Object> body = Optional.empty();
                if (ex == null) {
                    body = DefaultCompositeSObjectCollectionsApiClient.this.tryToReadListResponse(UpsertSObjectResult.class, response);
                }
                callback.onResponse(body, headers, ex);
            }
        });
    }

    @Override
    public void submitDeleteCompositeCollections(List<String> ids, Boolean allOrNone, Map<String, List<String>> headers, final CompositeSObjectCollectionsApiClient.ResponseCallback<List<DeleteSObjectResult>> callback) {
        String url = this.versionUrl() + "composite/sobjects";
        Request request = this.createRequest("DELETE", url, headers).param("ids", String.join((CharSequence)",", ids)).param("allOrNone", allOrNone.toString());
        this.doHttpRequest(request, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, Map<String, String> headers, SalesforceException ex) {
                Optional<Object> body = Optional.empty();
                if (ex == null) {
                    body = DefaultCompositeSObjectCollectionsApiClient.this.tryToReadListResponse(DeleteSObjectResult.class, response);
                }
                callback.onResponse(body, headers, ex);
            }
        });
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        List<RestError> errors;
        try {
            errors = this.readErrorsFrom(responseContent, PayloadFormat.JSON, this.mapper);
        }
        catch (IOException e) {
            return new SalesforceException("Unable to read error response", e);
        }
        int status = response.getStatus();
        if (status == 404) {
            return new NoSuchSObjectException(errors);
        }
        String reason = response.getReason();
        return new SalesforceException(errors, status, "Unexpected error: " + reason);
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put("Authorization", "Bearer " + this.accessToken);
    }

    private Request createRequest(String method, String url, Map<String, List<String>> headers) {
        Request request = this.getRequest(method, url, headers);
        return this.populateRequest(request);
    }

    private Request populateRequest(Request request) {
        this.setAccessToken(request);
        request.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        request.header(HttpHeader.ACCEPT, "application/json;charset=utf-8");
        return request;
    }

    private <T> List<T> fromJsonList(Class<T> expectedType, InputStream responseStream) throws IOException {
        CollectionType collectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, expectedType);
        return (List)this.mapper.readValue(responseStream, (JavaType)collectionType);
    }

    private ObjectWriter jsonWriterFor(Object obj) {
        Class<?> type = obj.getClass();
        return this.mapper.writerFor(type);
    }

    private ContentProvider serialize(Object body, Class<?> ... additionalTypes) throws SalesforceException {
        return new InputStreamContentProvider(this.toJson(body));
    }

    private String servicesDataUrl() {
        return this.instanceUrl + "/services/data/";
    }

    private InputStream toJson(Object obj) throws SalesforceException {
        byte[] jsonBytes;
        try {
            jsonBytes = this.jsonWriterFor(obj).writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new SalesforceException("Unable to serialize given SObjectTree to JSON", e);
        }
        return new ByteArrayInputStream(jsonBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<List<T>> tryToReadListResponse(Class<T> expectedType, InputStream responseStream) {
        if (responseStream == null) {
            return Optional.empty();
        }
        try {
            Optional<List<T>> optional = Optional.of(this.fromJsonList(expectedType, responseStream));
            return optional;
        }
        catch (IOException e) {
            this.log.warn("Unable to read response from the Composite API", (Throwable)e);
            Optional<List<T>> optional = Optional.empty();
            return optional;
        }
        finally {
            IOHelper.close((Closeable)responseStream);
        }
    }

    private String versionUrl() {
        ObjectHelper.notNull((Object)this.version, (String)"version");
        return this.servicesDataUrl() + "v" + this.version + "/";
    }
}

