/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.TypeReferences;
import org.apache.camel.component.salesforce.api.dto.AbstractDTOBase;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.Limits;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SearchResult2;
import org.apache.camel.component.salesforce.api.dto.UpsertSObjectResult;
import org.apache.camel.component.salesforce.api.dto.approval.ApprovalResult;
import org.apache.camel.component.salesforce.api.dto.approval.Approvals;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.internal.processor.AbstractRestProcessor;

public class JsonRestProcessor
extends AbstractRestProcessor {
    private static final String RESPONSE_TYPE = JsonRestProcessor.class.getName() + ".responseType";
    private final ObjectMapper objectMapper;

    public JsonRestProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
        this.objectMapper = endpoint.getConfiguration().getObjectMapper() != null ? endpoint.getConfiguration().getObjectMapper() : JsonUtils.createObjectMapper();
    }

    @Override
    protected void processRequest(Exchange exchange) throws SalesforceException {
        switch (this.operationName) {
            case GET_VERSIONS: {
                exchange.setProperty(RESPONSE_TYPE, TypeReferences.VERSION_LIST_TYPE);
                break;
            }
            case GET_RESOURCES: {
                exchange.setProperty(RESPONSE_TYPE, (Object)new TypeReference<Map<String, String>>(){});
                break;
            }
            case GET_GLOBAL_OBJECTS: {
                exchange.setProperty(RESPONSE_CLASS, GlobalObjects.class);
                break;
            }
            case GET_BASIC_INFO: {
                exchange.setProperty(RESPONSE_CLASS, SObjectBasicInfo.class);
                break;
            }
            case GET_DESCRIPTION: {
                exchange.setProperty(RESPONSE_CLASS, SObjectDescription.class);
                break;
            }
            case CREATE_SOBJECT: {
                exchange.setProperty(RESPONSE_CLASS, CreateSObjectResult.class);
                break;
            }
            case UPSERT_SOBJECT: {
                exchange.setProperty(RESPONSE_CLASS, UpsertSObjectResult.class);
                break;
            }
            case SEARCH: {
                if (Double.parseDouble(this.endpoint.getConfiguration().getApiVersion()) >= 37.0) {
                    exchange.setProperty(RESPONSE_CLASS, SearchResult2.class);
                    break;
                }
                exchange.setProperty(RESPONSE_TYPE, TypeReferences.SEARCH_RESULT_TYPE);
                break;
            }
            case RECENT: {
                exchange.setProperty(RESPONSE_TYPE, TypeReferences.RECENT_ITEM_LIST_TYPE);
                break;
            }
            case LIMITS: {
                exchange.setProperty(RESPONSE_CLASS, Limits.class);
                break;
            }
            case APPROVAL: {
                exchange.setProperty(RESPONSE_CLASS, ApprovalResult.class);
                break;
            }
            case APPROVALS: {
                exchange.setProperty(RESPONSE_CLASS, Approvals.class);
                break;
            }
        }
    }

    @Override
    protected InputStream getRequestStream(Exchange exchange) throws SalesforceException {
        Message in = exchange.getIn();
        InputStream request = (InputStream)in.getBody(InputStream.class);
        if (request == null) {
            AbstractDTOBase dto = (AbstractDTOBase)in.getBody(AbstractDTOBase.class);
            if (dto != null) {
                request = this.getRequestStream(in, dto);
            } else {
                String body = (String)in.getBody(String.class);
                if (null == body) {
                    String msg = "Unsupported request message body " + (in.getBody() == null ? null : in.getBody().getClass());
                    throw new SalesforceException(msg, null);
                }
                request = new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
            }
        }
        return request;
    }

    @Override
    protected InputStream getRequestStream(Message in, Object object) throws SalesforceException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue((OutputStream)out, object);
        }
        catch (IOException e) {
            String msg = "Error marshaling request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processResponse(Exchange exchange, InputStream responseEntity, Map<String, String> headers, SalesforceException ex, AsyncCallback callback) {
        try {
            Message out = exchange.getOut();
            Message in = exchange.getIn();
            out.copyFrom(in);
            out.getHeaders().putAll(headers);
            if (ex != null) {
                if (this.shouldReport(ex)) {
                    exchange.setException((Throwable)((Object)ex));
                } else {
                    out.setBody(null);
                }
            } else if (responseEntity != null) {
                Object response;
                Class responseClass = (Class)exchange.getProperty(RESPONSE_CLASS, Class.class);
                if (!this.rawPayload && responseClass != null) {
                    response = this.objectMapper.readValue(responseEntity, responseClass);
                } else {
                    TypeReference responseType = (TypeReference)exchange.getProperty(RESPONSE_TYPE, TypeReference.class);
                    response = !this.rawPayload && responseType != null ? this.objectMapper.readValue(responseEntity, responseType) : responseEntity;
                }
                out.setBody(response);
            }
        }
        catch (IOException e) {
            String msg = "Error parsing JSON response: " + e.getMessage();
            exchange.setException((Throwable)((Object)new SalesforceException(msg, e)));
        }
        finally {
            exchange.removeProperty(RESPONSE_CLASS);
            exchange.removeProperty(RESPONSE_TYPE);
            try {
                if (responseEntity != null) {
                    responseEntity.close();
                }
            }
            catch (IOException iOException) {}
            callback.done(false);
        }
    }
}

