/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectCollection;
import org.apache.camel.component.salesforce.internal.client.CompositeSObjectCollectionsApiClient;
import org.apache.camel.component.salesforce.internal.client.DefaultCompositeSObjectCollectionsApiClient;
import org.apache.camel.component.salesforce.internal.dto.composite.RetrieveSObjectCollectionsDto;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.support.service.ServiceHelper;

public class CompositeSObjectCollectionsProcessor
extends AbstractSalesforceProcessor {
    private CompositeSObjectCollectionsApiClient compositeClient;
    private Map<String, Class<?>> classMap;

    public CompositeSObjectCollectionsProcessor(SalesforceEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SalesforceEndpointConfig configuration = this.endpoint.getConfiguration();
        String apiVersion = configuration.getApiVersion();
        this.compositeClient = new DefaultCompositeSObjectCollectionsApiClient(configuration, apiVersion, this.session, this.httpClient, this.loginConfig);
        if (this.classMap == null) {
            this.classMap = this.endpoint.getComponent().getClassMap();
        }
        ServiceHelper.startService((Object)this.compositeClient);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.compositeClient);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            switch (this.operationName) {
                case COMPOSITE_CREATE_SOBJECT_COLLECTIONS: {
                    return this.processCreateSObjectCollections(exchange, callback);
                }
                case COMPOSITE_UPDATE_SOBJECT_COLLECTIONS: {
                    return this.processUpdateSObjectCollections(exchange, callback);
                }
                case COMPOSITE_UPSERT_SOBJECT_COLLECTIONS: {
                    return this.processUpsertSObjectCollections(exchange, callback);
                }
                case COMPOSITE_RETRIEVE_SOBJECT_COLLECTIONS: {
                    return this.processRetrieveSObjectCollections(exchange, callback);
                }
                case COMPOSITE_DELETE_SOBJECT_COLLECTIONS: {
                    return this.processDeleteSObjectCollections(exchange, callback);
                }
            }
            throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
        }
        catch (SalesforceException e) {
            return this.processException(exchange, callback, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            SalesforceException exception = new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e);
            return this.processException(exchange, callback, (Exception)((Object)exception));
        }
    }

    private boolean processRetrieveSObjectCollections(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        List<String> ids = this.getListParameter("sObjectIds", exchange, true, false);
        List<String> fields = this.getListParameter("sObjectFields", exchange, true, false);
        String sObjectName = this.getParameter("sObjectName", exchange, false, true);
        Class<?> sObjectClass = this.getSObjectClass(exchange);
        RetrieveSObjectCollectionsDto request = new RetrieveSObjectCollectionsDto(ids, fields);
        this.compositeClient.submitRetrieveCompositeCollections(request, this.determineHeaders(exchange), (response, responseHeaders, exception) -> this.processResponse(exchange, response, responseHeaders, exception, callback), sObjectName, sObjectClass);
        return false;
    }

    private boolean processCreateSObjectCollections(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        SObjectCollection collection = this.buildSObjectCollection(exchange);
        this.compositeClient.createCompositeCollections(collection, this.determineHeaders(exchange), (response, responseHeaders, exception) -> this.processResponse(exchange, response, responseHeaders, exception, callback));
        return false;
    }

    private boolean processUpdateSObjectCollections(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        SObjectCollection collection = this.buildSObjectCollection(exchange);
        this.compositeClient.updateCompositeCollections(collection, this.determineHeaders(exchange), (response, responseHeaders, exception) -> this.processResponse(exchange, response, responseHeaders, exception, callback));
        return false;
    }

    private boolean processUpsertSObjectCollections(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        SObjectCollection collection = this.buildSObjectCollection(exchange);
        String externalIdFieldName = this.getParameter("sObjectIdName", exchange, false, false);
        String sObjectName = this.getParameter("sObjectName", exchange, false, false);
        this.compositeClient.upsertCompositeCollections(collection, this.determineHeaders(exchange), (response, responseHeaders, exception) -> this.processResponse(exchange, response, responseHeaders, exception, callback), sObjectName, externalIdFieldName);
        return false;
    }

    private boolean processDeleteSObjectCollections(Exchange exchange, AsyncCallback callback) throws SalesforceException {
        List<String> ids = this.getListParameter("sObjectIds", exchange, true, false);
        boolean allOrNone = Boolean.parseBoolean(this.getParameter("allOrNone", exchange, false, true));
        this.compositeClient.submitDeleteCompositeCollections(ids, allOrNone, this.determineHeaders(exchange), (response, responseHeaders, exception) -> this.processResponse(exchange, response, responseHeaders, exception, callback));
        return false;
    }

    private SObjectCollection buildSObjectCollection(Exchange exchange) throws SalesforceException {
        List body;
        Message in = exchange.getIn();
        try {
            body = (List)in.getMandatoryBody();
        }
        catch (InvalidPayloadException e) {
            throw new SalesforceException(e);
        }
        SObjectCollection collection = new SObjectCollection();
        collection.setRecords(body);
        boolean allOrNone = Boolean.parseBoolean(this.getParameter("allOrNone", exchange, true, true));
        collection.setAllOrNone(allOrNone);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(Exchange exchange, Optional<? extends List<?>> responseBody, Map<String, String> headers, SalesforceException exception, AsyncCallback callback) {
        try {
            if (exception != null) {
                exchange.setException((Throwable)((Object)exception));
            } else {
                Message in = exchange.getIn();
                Message out = exchange.getOut();
                List<?> response = responseBody.get();
                out.copyFromWithNewBody(in, response);
                out.getHeaders().putAll(headers);
            }
        }
        finally {
            callback.done(false);
        }
    }

    private boolean processException(Exchange exchange, AsyncCallback callback, Exception e) {
        exchange.setException((Throwable)e);
        callback.done(true);
        return true;
    }
}

