/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.NullSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.StringSchema;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.component.salesforce.api.FieldsToNullPropertyFilter;
import org.apache.camel.component.salesforce.api.dto.AbstractDTOBase;
import org.apache.camel.component.salesforce.api.dto.AbstractQueryRecordsBase;
import org.apache.camel.component.salesforce.api.dto.Address;
import org.apache.camel.component.salesforce.api.dto.GeoLocation;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.PickListValue;
import org.apache.camel.component.salesforce.api.dto.SObject;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SObjectField;
import org.apache.camel.component.salesforce.api.utils.TimeModule;
import org.apache.camel.support.scan.DefaultPackageScanClassResolver;

public final class JsonUtils {
    public static final String SCHEMA4 = "http://json-schema.org/draft-04/schema#";
    public static final String DEFAULT_ID_PREFIX = "urn:jsonschema:org:apache:camel:component:salesforce:dto";
    private static final String API_DTO_ID = "org:urn:jsonschema:org:apache:camel:component:salesforce:api:dto";

    private JsonUtils() {
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("fieldsToNull", (SimpleBeanPropertyFilter)new FieldsToNullPropertyFilter());
        objectMapper.setFilterProvider((FilterProvider)filterProvider);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
        objectMapper.registerModule((Module)new TimeModule());
        return objectMapper;
    }

    public static String getBasicApiJsonSchema() throws JsonProcessingException {
        ObjectMapper mapper = JsonUtils.createSchemaObjectMapper();
        JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
        DefaultPackageScanClassResolver packageScanClassResolver = new DefaultPackageScanClassResolver();
        HashSet schemaClasses = new HashSet();
        schemaClasses.addAll(packageScanClassResolver.findByFilter(type -> !Modifier.isAbstract(type.getModifiers()) && AbstractDTOBase.class.isAssignableFrom(type), new String[]{"org.apache.camel.component.salesforce.api.dto"}));
        schemaClasses.addAll(packageScanClassResolver.findByFilter(type -> !Modifier.isAbstract(type.getModifiers()) && AbstractDTOBase.class.isAssignableFrom(type), new String[]{"org.apache.camel.component.salesforce.api.dto"}));
        HashSet<JsonSchema> allSchemas = new HashSet<JsonSchema>();
        for (Class aClass : schemaClasses) {
            JsonSchema jsonSchema = schemaGen.generateSchema(aClass);
            allSchemas.add(jsonSchema);
        }
        return JsonUtils.getJsonSchemaString(mapper, allSchemas, API_DTO_ID);
    }

    public static String getJsonSchemaString(ObjectMapper mapper, Set<JsonSchema> allSchemas, String id) throws JsonProcessingException {
        JsonSchema rootSchema = JsonUtils.getJsonSchemaAsSchema(allSchemas, id);
        return mapper.writeValueAsString((Object)rootSchema);
    }

    public static JsonSchema getJsonSchemaAsSchema(Set<JsonSchema> allSchemas, String id) {
        ObjectSchema rootSchema = new ObjectSchema();
        rootSchema.set$schema(SCHEMA4);
        rootSchema.setId(id);
        Set<JsonSchema> tmp = allSchemas;
        rootSchema.setOneOf(tmp);
        return rootSchema;
    }

    public static String getSObjectJsonSchema(SObjectDescription description) throws JsonProcessingException {
        return JsonUtils.getSObjectJsonSchema(description, true);
    }

    public static JsonSchema getSObjectJsonSchemaAsJson(SObjectDescription description) throws JsonProcessingException {
        return JsonUtils.getSObjectJsonSchemaAsSchema(description, true);
    }

    public static String getSObjectJsonSchema(SObjectDescription description, boolean addQuerySchema) throws JsonProcessingException {
        ObjectMapper schemaObjectMapper = JsonUtils.createSchemaObjectMapper();
        return JsonUtils.getJsonSchemaString(schemaObjectMapper, JsonUtils.getSObjectJsonSchema(schemaObjectMapper, description, DEFAULT_ID_PREFIX, addQuerySchema), DEFAULT_ID_PREFIX);
    }

    public static JsonSchema getSObjectJsonSchemaAsSchema(SObjectDescription description, boolean addQuerySchema) throws JsonProcessingException {
        ObjectMapper schemaObjectMapper = JsonUtils.createSchemaObjectMapper();
        return JsonUtils.getJsonSchemaAsSchema(JsonUtils.getSObjectJsonSchema(schemaObjectMapper, description, DEFAULT_ID_PREFIX, addQuerySchema), DEFAULT_ID_PREFIX);
    }

    public static Set<JsonSchema> getSObjectJsonSchema(ObjectMapper objectMapper, SObjectDescription description, String idPrefix, boolean addQuerySchema) throws JsonProcessingException {
        HashSet<JsonSchema> allSchemas = new HashSet<JsonSchema>();
        ObjectSchema sobjectSchema = new ObjectSchema();
        sobjectSchema.setId(idPrefix + ":" + description.getName());
        sobjectSchema.setTitle(description.getLabel());
        ObjectSchema addressSchema = null;
        ObjectSchema geoLocationSchema = null;
        for (SObjectField field : description.getFields()) {
            NullSchema fieldSchema = new NullSchema();
            String soapType = field.getSoapType();
            switch (soapType.substring(soapType.indexOf(58) + 1)) {
                case "ID": 
                case "string": 
                case "base64Binary": 
                case "anyType": {
                    fieldSchema = new StringSchema();
                    break;
                }
                case "integer": 
                case "int": 
                case "long": 
                case "short": 
                case "byte": 
                case "unsignedInt": 
                case "unsignedShort": 
                case "unsignedByte": {
                    fieldSchema = new IntegerSchema();
                    break;
                }
                case "decimal": 
                case "float": 
                case "double": {
                    fieldSchema = new NumberSchema();
                    break;
                }
                case "boolean": {
                    fieldSchema = new BooleanSchema();
                    break;
                }
                case "date": {
                    fieldSchema = new StringSchema();
                    ((StringSchema)fieldSchema).setFormat(JsonValueFormat.DATE);
                    break;
                }
                case "dateTime": 
                case "g": {
                    fieldSchema = new StringSchema();
                    ((StringSchema)fieldSchema).setFormat(JsonValueFormat.DATE_TIME);
                    break;
                }
                case "time": {
                    fieldSchema = new StringSchema();
                    ((StringSchema)fieldSchema).setFormat(JsonValueFormat.TIME);
                    break;
                }
                case "address": {
                    if (addressSchema == null) {
                        addressSchema = JsonUtils.getSchemaFromClass(objectMapper, Address.class);
                    }
                    fieldSchema = addressSchema;
                    break;
                }
                case "location": {
                    if (geoLocationSchema == null) {
                        geoLocationSchema = JsonUtils.getSchemaFromClass(objectMapper, GeoLocation.class);
                    }
                    fieldSchema = geoLocationSchema;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type " + soapType);
                }
            }
            List<PickListValue> picklistValues = field.getPicklistValues();
            switch (field.getType()) {
                case "picklist": {
                    fieldSchema.asStringSchema().setEnums(picklistValues == null ? Collections.emptySet() : picklistValues.stream().map(PickListValue::getValue).distinct().collect(Collectors.toSet()));
                    break;
                }
                case "multipicklist": {
                    fieldSchema.asStringSchema().setPattern(picklistValues == null ? "" : picklistValues.stream().map(val -> "(,?(" + val.getValue() + "))").distinct().collect(Collectors.joining("|", "(", ")")));
                    break;
                }
            }
            fieldSchema.setTitle(field.getLabel());
            fieldSchema.setDefault(field.getDefaultValue());
            if (field.isUpdateable() != null) {
                fieldSchema.setReadonly(Boolean.valueOf(field.isUpdateable() == false));
            }
            String descriptionText = Arrays.asList({"unique", field.isUnique()}, {"idLookup", field.isIdLookup()}, {"autoNumber", field.isAutoNumber()}, {"calculated", field.isCalculated()}).stream().filter(ary -> Boolean.TRUE.equals(ary[1])).map(ary -> String.valueOf(ary[0])).collect(Collectors.joining(","));
            fieldSchema.setDescription(descriptionText);
            if (field.isNillable().booleanValue()) {
                sobjectSchema.putOptionalProperty(field.getName(), (JsonSchema)fieldSchema);
                continue;
            }
            sobjectSchema.putProperty(field.getName(), (JsonSchema)fieldSchema);
        }
        allSchemas.add((JsonSchema)sobjectSchema);
        if (addQuerySchema) {
            ObjectSchema queryRecords = JsonUtils.getSchemaFromClass(objectMapper, AbstractQueryRecordsBase.class);
            queryRecords.setId(idPrefix + ":QueryRecords" + description.getName());
            ObjectSchema refSchema = new ObjectSchema();
            refSchema.set$ref(sobjectSchema.getId());
            ArraySchema recordsProperty = new ArraySchema();
            recordsProperty.setItems((ArraySchema.Items)new ArraySchema.SingleItems((JsonSchema)refSchema));
            queryRecords.putProperty("records", (JsonSchema)recordsProperty);
            allSchemas.add((JsonSchema)queryRecords);
        }
        return allSchemas;
    }

    public static ObjectMapper createSchemaObjectMapper() {
        ObjectMapper objectMapper = JsonUtils.createObjectMapper();
        objectMapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        return objectMapper;
    }

    private static ObjectSchema getSchemaFromClass(ObjectMapper objectMapper, Class<?> type) throws JsonMappingException {
        return new JsonSchemaGenerator(objectMapper).generateSchema(type).asObjectSchema();
    }

    public static JsonSchema getGlobalObjectsJsonSchemaAsSchema(GlobalObjects globalObjects) {
        HashSet<JsonSchema> allSchemas = new HashSet<JsonSchema>();
        for (SObject sobject : globalObjects.getSobjects()) {
            ObjectSchema sobjectSchema = new ObjectSchema();
            sobjectSchema.setId("urn:jsonschema:org:apache:camel:component:salesforce:dto:" + sobject.getName());
            sobjectSchema.setTitle(sobject.getLabel());
            allSchemas.add((JsonSchema)sobjectSchema);
        }
        return JsonUtils.getJsonSchemaAsSchema(allSchemas, "urn:jsonschema:org:apache:camel:component:salesforce:dto:GlobalObjects");
    }

    public static ObjectMapper withNullSerialization(ObjectMapper objectMapper) {
        SerializerFactory factory = BeanSerializerFactory.instance.withSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                for (PropertyWriter writer : () -> serializer.properties()) {
                    if (!(writer instanceof BeanPropertyWriter)) continue;
                    ((BeanPropertyWriter)writer).assignNullSerializer((JsonSerializer)NullSerializer.instance);
                }
                return serializer;
            }
        });
        return objectMapper.copy().setSerializerFactory(factory);
    }
}

