/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.script.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.util.IOHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleTrackerCustomizer,
ServiceListener {
    public static final String META_INF_SERVICES_DIR = "META-INF/services";
    public static final String SCRIPT_ENGINE_SERVICE_FILE = "javax.script.ScriptEngineFactory";
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private BundleTracker tracker;
    private ServiceRegistration<LanguageResolver> registration;
    private Map<Long, List<BundleScriptEngineResolver>> resolvers = new ConcurrentHashMap<Long, List<BundleScriptEngineResolver>>();

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        LOG.info("Camel-Script activator starting");
        this.tracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
        this.tracker.open();
        context.addServiceListener((ServiceListener)this, "(&(resolver=default)(objectClass=org.apache.camel.spi.LanguageResolver))");
        LOG.info("Camel-Script activator started");
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info("Camel-Script activator stopping");
        this.tracker.close();
        context.removeServiceListener((ServiceListener)this);
        if (this.registration != null) {
            this.registration.unregister();
        }
        LOG.info("Camel-Script activator stopped");
        Activator.context = null;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        ArrayList<BundleScriptEngineResolver> r = new ArrayList<BundleScriptEngineResolver>();
        this.registerScriptEngines(bundle, r);
        for (BundleScriptEngineResolver service : r) {
            service.register();
        }
        this.resolvers.put(bundle.getBundleId(), r);
        if (r.size() > 0) {
            this.updateAvailableScriptLanguages();
        }
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        LOG.debug("Bundle stopped: {}", (Object)bundle.getSymbolicName());
        List<BundleScriptEngineResolver> r = this.resolvers.remove(bundle.getBundleId());
        if (r != null) {
            this.updateAvailableScriptLanguages();
            for (BundleScriptEngineResolver service : r) {
                service.unregister();
            }
        }
    }

    private String[] getAvailableScriptNames() {
        TreeSet names = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (List<BundleScriptEngineResolver> list : this.resolvers.values()) {
            for (BundleScriptEngineResolver r : list) {
                names.addAll(r.getScriptNames());
            }
        }
        return names.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailableScriptLanguages() {
        ServiceReference ref = null;
        try {
            Collection references = context.getServiceReferences(LanguageResolver.class, "(resolver=default)");
            if (references.size() == 1) {
                if (this.registration != null) {
                    this.registration.unregister();
                    this.registration = null;
                }
                ref = (ServiceReference)references.iterator().next();
                LanguageResolver resolver = (LanguageResolver)context.getService(ref);
                Hashtable<String, String[]> props = new Hashtable<String, String[]>();
                ((Dictionary)props).put("language", this.getAvailableScriptNames());
                this.registration = context.registerService(LanguageResolver.class, (Object)resolver, props);
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Invalid syntax for LanguageResolver service reference filter.");
        }
        finally {
            if (ref != null) {
                context.ungetService(ref);
            }
        }
    }

    public static ScriptEngine resolveScriptEngine(String scriptEngineName) throws InvalidSyntaxException {
        ServiceReference[] refs = context.getServiceReferences(ScriptEngineResolver.class.getName(), null);
        if (refs == null) {
            LOG.info("No OSGi script engine resolvers available!");
            return null;
        }
        LOG.debug("Found {} OSGi ScriptEngineResolver services", (Object)refs.length);
        for (ServiceReference ref : refs) {
            ScriptEngineResolver resolver = (ScriptEngineResolver)context.getService(ref);
            ScriptEngine engine = resolver.resolveScriptEngine(scriptEngineName);
            context.ungetService(ref);
            LOG.debug("OSGi resolver " + resolver + " produced " + scriptEngineName + " engine " + engine);
            if (engine == null) continue;
            return engine;
        }
        return null;
    }

    protected void registerScriptEngines(Bundle bundle, List<BundleScriptEngineResolver> resolvers) {
        try {
            Enumeration<URL> e = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader().getResources("META-INF/services/javax.script.ScriptEngineFactory");
            while (e != null && e.hasMoreElements()) {
                URL configURL = e.nextElement();
                LOG.info("Found ScriptEngineFactory in bundle: {}", (Object)bundle.getSymbolicName());
                resolvers.add(new BundleScriptEngineResolver(bundle, configURL));
            }
        }
        catch (IOException e) {
            LOG.info("Error loading script engine factory", (Throwable)e);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        this.updateAvailableScriptLanguages();
    }

    protected static class BundleScriptEngineResolver
    implements ScriptEngineResolver {
        protected final Bundle bundle;
        private ServiceRegistration<?> reg;
        private final URL configFile;

        public BundleScriptEngineResolver(Bundle bundle, URL configFile) {
            this.bundle = bundle;
            this.configFile = configFile;
        }

        public void register() {
            this.reg = this.bundle.getBundleContext().registerService(ScriptEngineResolver.class.getName(), (Object)this, null);
        }

        public void unregister() {
            this.reg.unregister();
        }

        private List<String> getScriptNames() {
            return this.getScriptNames(this.getFactory());
        }

        private List<String> getScriptNames(ScriptEngineFactory factory) {
            List<String> names = factory != null ? factory.getNames() : Collections.EMPTY_LIST;
            return names;
        }

        private ScriptEngineFactory getFactory() {
            try {
                String className;
                BufferedReader in = IOHelper.buffered((Reader)new InputStreamReader(this.configFile.openStream()));
                while ((className = in.readLine()) != null) {
                    if ("".equals(className.trim()) || className.trim().startsWith("#")) continue;
                    className = className.contains("#") ? className.substring(0, className.indexOf(35)).trim() : className.trim();
                    break;
                }
                in.close();
                Class cls = this.bundle.loadClass(className);
                if (!ScriptEngineFactory.class.isAssignableFrom(cls)) {
                    return null;
                }
                return (ScriptEngineFactory)cls.newInstance();
            }
            catch (Exception e) {
                LOG.warn("Cannot create the ScriptEngineFactory: {}", (Object)e.getClass().getName(), (Object)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScriptEngine resolveScriptEngine(String name) {
            block6: {
                try {
                    ScriptEngineFactory factory = this.getFactory();
                    if (factory == null) break block6;
                    List<String> names = this.getScriptNames(factory);
                    for (String test : names) {
                        ScriptEngine engine;
                        if (!test.equals(name)) continue;
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
                            engine = factory.getScriptEngine();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                        LOG.trace("Resolved ScriptEngineFactory: {} for expected name: {}", (Object)engine, (Object)name);
                        return engine;
                    }
                    LOG.debug("ScriptEngineFactory: {} does not match expected name: {}", (Object)factory.getEngineName(), (Object)name);
                    return null;
                }
                catch (Exception e) {
                    LOG.warn("Cannot create ScriptEngineFactory: {}", (Object)e.getClass().getName(), (Object)e);
                    return null;
                }
            }
            return null;
        }

        public String toString() {
            return "OSGi script engine resolver for " + this.bundle.getSymbolicName();
        }
    }

    public static interface ScriptEngineResolver {
        public ScriptEngine resolveScriptEngine(String var1);
    }
}

