/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.ObjectHelper;

class HelsinkiServiceNowServiceCatalogProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowServiceCatalogProcessor(ServiceNowEndpoint endpoint) {
        super(endpoint);
        this.addDispatcher("retrieve", "categories", this::retrieveCatalogsCategories);
        this.addDispatcher("retrieve", this::retrieveCatalogs);
    }

    private void retrieveCatalogs(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = ObjectHelper.isEmpty((Object)sysId) ? this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("catalogs").query(ServiceNowParams.SYSPARM_LIMIT, in).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET") : this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("catalogs").path(sysId).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void retrieveCatalogsCategories(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Class<?> responseModel = this.getResponseModel(in);
        String sysId = this.getSysID(in);
        String apiVersion = this.getApiVersion(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("sn_sc").path(apiVersion).path("servicecatalog").path("catalogs").path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).path("categories").query(ServiceNowParams.SYSPARM_TOP_LEVEL_ONLY, in).query(ServiceNowParams.SYSPARM_LIMIT, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(ServiceNowParams.SYSPARM_OFFSET, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

