/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.fuji;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.component.servicenow.releases.fuji.FujiServiceNowProcessor;
import org.apache.camel.util.ObjectHelper;

class FujiServiceNowTableProcessor
extends FujiServiceNowProcessor {
    FujiServiceNowTableProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, Class<?> requestModel, Class<?> responseModel, String apiVersion, String action, String tableName, String sysId) throws Exception {
        Response response;
        if (ObjectHelper.equal((Object)"retrieve", (Object)action, (boolean)true)) {
            response = this.retrieveRecord(exchange.getIn(), responseModel, apiVersion, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"create", (Object)action, (boolean)true)) {
            response = this.createRecord(exchange.getIn(), requestModel, responseModel, apiVersion, tableName);
        } else if (ObjectHelper.equal((Object)"modify", (Object)action, (boolean)true)) {
            response = this.modifyRecord(exchange.getIn(), requestModel, responseModel, apiVersion, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"delete", (Object)action, (boolean)true)) {
            response = this.deleteRecord(responseModel, apiVersion, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"update", (Object)action, (boolean)true)) {
            response = this.updateRecord(exchange.getIn(), requestModel, responseModel, apiVersion, tableName, sysId);
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private Response retrieveRecord(Message in, Class<?> responseModel, String apiVersion, String tableName, String sysId) throws Exception {
        return ObjectHelper.isEmpty((String)sysId) ? this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_LIMIT, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET") : this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(sysId).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("GET");
    }

    private Response createRecord(Message in, Class<?> requestModel, Class<?> responseModel, String apiVersion, String tableName) throws Exception {
        this.validateBody(in, requestModel);
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_INPUT_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_SUPPRESS_AUTO_SYS_FIELD, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("POST", in.getMandatoryBody());
    }

    private Response modifyRecord(Message in, Class<?> requestModel, Class<?> responseModel, String apiVersion, String tableName, String sysId) throws Exception {
        this.validateBody(in, requestModel);
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_INPUT_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_SUPPRESS_AUTO_SYS_FIELD, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("PUT", in.getMandatoryBody());
    }

    private Response deleteRecord(Class<?> responseModel, String apiVersion, String tableName, String sysId) throws Exception {
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).query(responseModel).invoke("DELETE");
    }

    private Response updateRecord(Message in, Class<?> requestModel, Class<?> responseModel, String apiVersion, String tableName, String sysId) throws Exception {
        this.validateBody(in, requestModel);
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("table").path(tableName).path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_EXCLUDE_REFERENCE_LINK, in).query(ServiceNowParams.SYSPARM_FIELDS, in).query(ServiceNowParams.SYSPARM_INPUT_DISPLAY_VALUE, in).query(ServiceNowParams.SYSPARM_SUPPRESS_AUTO_SYS_FIELD, in).query(ServiceNowParams.SYSPARM_VIEW, in).query(responseModel).invoke("PATCH", in.getMandatoryBody());
    }
}

