/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.HttpRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpRegistry
implements HttpRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpRegistry.class);
    private static Map<String, HttpRegistry> registries = new HashMap<String, HttpRegistry>();
    private final Set<HttpConsumer> consumers = new HashSet<HttpConsumer>();
    private final Set<CamelServlet> providers = new HashSet<CamelServlet>();

    public static synchronized HttpRegistry getHttpRegistry(String name) {
        HttpRegistry answer = registries.get(name);
        if (answer == null) {
            answer = new DefaultHttpRegistry();
            registries.put(name, answer);
        }
        return answer;
    }

    public static synchronized void removeHttpRegistry(String name) {
        registries.remove(name);
    }

    @Override
    public void register(HttpConsumer consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering consumer for path {} providers present: {}", (Object)consumer.getPath(), (Object)this.providers.size());
        }
        this.consumers.add(consumer);
        for (CamelServlet provider : this.providers) {
            provider.connect(consumer);
        }
    }

    @Override
    public void unregister(HttpConsumer consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unregistering consumer for path {}", (Object)consumer.getPath());
        }
        this.consumers.remove(consumer);
        for (CamelServlet provider : this.providers) {
            provider.disconnect(consumer);
        }
    }

    public void register(CamelServlet provider, Map properties) {
        CamelServlet camelServlet = provider;
        camelServlet.setServletName((String)properties.get("servlet-name"));
        this.register(camelServlet);
    }

    public void unregister(CamelServlet provider, Map<String, Object> properties) {
        this.unregister(provider);
    }

    @Override
    public void register(CamelServlet provider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering CamelServlet with name {} consumers present: {}", (Object)provider.getServletName(), (Object)this.consumers.size());
        }
        this.providers.add(provider);
        for (HttpConsumer consumer : this.consumers) {
            provider.connect(consumer);
        }
    }

    @Override
    public void unregister(CamelServlet provider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unregistering CamelServlet with name {}", (Object)provider.getServletName());
        }
        this.providers.remove(provider);
    }

    @Override
    public CamelServlet getCamelServlet(String servletName) {
        for (CamelServlet provider : this.providers) {
            if (!provider.getServletName().equals(servletName)) continue;
            return provider;
        }
        return null;
    }

    public void setServlets(List<Servlet> servlets) {
        this.providers.clear();
        for (Servlet servlet : servlets) {
            if (!(servlet instanceof CamelServlet)) continue;
            this.providers.add((CamelServlet)servlet);
        }
    }
}

