/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SipEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":uri";
    private static final String[] SCHEMES = new String[]{"sip", "sips"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "uri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(45);
        props.add("addressFactory");
        props.add("messageFactory");
        props.add("contentTypeHeader");
        props.add("presenceAgent");
        props.add("fromPort");
        props.add("fromUser");
        props.add("eventHeader");
        props.add("viaHeaders");
        props.add("stackName");
        props.add("receiveTimeoutMillis");
        props.add("sipUri");
        props.add("implementationServerLogFile");
        props.add("toUser");
        props.add("listeningPoint");
        props.add("msgExpiration");
        props.add("eventHeaderName");
        props.add("bridgeErrorHandler");
        props.add("extensionHeader");
        props.add("expiresHeader");
        props.add("maxMessageSize");
        props.add("useRouterForAllUris");
        props.add("contentType");
        props.add("toHeader");
        props.add("consumer");
        props.add("contactHeader");
        props.add("implementationDebugLogFile");
        props.add("eventId");
        props.add("maxForwards");
        props.add("maxForwardsHeader");
        props.add("cacheConnections");
        props.add("sipFactory");
        props.add("toPort");
        props.add("exchangePattern");
        props.add("fromHeader");
        props.add("transport");
        props.add("contentSubType");
        props.add("uri");
        props.add("headerFactory");
        props.add("lazyStartProducer");
        props.add("sipStack");
        props.add("toHost");
        props.add("implementationTraceLevel");
        props.add("callIdHeader");
        props.add("fromHost");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

