/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.producer;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.BatchMessage;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;

public class InOnlyProducer
extends SjmsProducer {
    public InOnlyProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected TransactionCommitStrategy getCommitStrategy() {
        if (this.isEndpointTransacted()) {
            return super.getCommitStrategy() == null ? new DefaultTransactionCommitStrategy() : super.getCommitStrategy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, MessageProducerResources producer, SjmsProducer.ReleaseProducerCallback releaseProducerCallback) throws Exception {
        try {
            Message message;
            ArrayList<Message> messages = new ArrayList<Message>(1);
            if (exchange.getIn().getBody() != null) {
                if (exchange.getIn().getBody() instanceof List) {
                    Iterable payload = (Iterable)exchange.getIn().getBody();
                    for (Object object : payload) {
                        Message message2;
                        if (BatchMessage.class.isInstance(object)) {
                            BatchMessage batchMessage = (BatchMessage)object;
                            message2 = this.getEndpoint().getBinding().makeJmsMessage(exchange, batchMessage.getPayload(), batchMessage.getHeaders(), producer.getSession(), null);
                        } else {
                            message2 = this.getEndpoint().getBinding().makeJmsMessage(exchange, object, exchange.getIn().getHeaders(), producer.getSession(), null);
                        }
                        messages.add(message2);
                    }
                } else {
                    message = this.getEndpoint().getBinding().makeJmsMessage(exchange, producer.getSession());
                    messages.add(message);
                }
            } else {
                message = this.getEndpoint().getBinding().makeJmsMessage(exchange, producer.getSession());
                messages.add(message);
            }
            for (Message message3 : messages) {
                producer.getMessageProducer().send(message3);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)new Exception("Unable to complete sending the message: ", e));
        }
        finally {
            releaseProducerCallback.release(producer);
            callback.done(this.isSynchronous());
        }
    }
}

