/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.io.File;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.sjms.jms.JmsBinding;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjmsMessage
extends DefaultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(SjmsMessage.class);
    private javax.jms.Message jmsMessage;
    private Session jmsSession;
    private JmsBinding binding;

    public SjmsMessage(Exchange exchange, javax.jms.Message jmsMessage, Session jmsSession, JmsBinding binding) {
        super(exchange);
        this.setJmsMessage(jmsMessage);
        this.setJmsSession(jmsSession);
        this.setBinding(binding);
    }

    public void init(Exchange exchange, javax.jms.Message jmsMessage, Session jmsSession, JmsBinding binding) {
        this.setExchange(exchange);
        this.setJmsMessage(jmsMessage);
        this.setJmsSession(jmsSession);
        this.setBinding(binding);
        this.populateInitialHeaders(this.getHeaders());
    }

    public void reset() {
        super.reset();
        this.setExchange(null);
        this.jmsMessage = null;
        this.jmsSession = null;
        this.binding = null;
    }

    public String toString() {
        if (this.jmsMessage != null) {
            try {
                return "SjmsMessage[JmsMessageID: " + this.jmsMessage.getJMSMessageID() + "]";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "SjmsMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }

    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        this.getHeaders().clear();
        boolean copyMessageId = true;
        if (that instanceof SjmsMessage) {
            SjmsMessage thatMessage = (SjmsMessage)that;
            this.jmsMessage = thatMessage.jmsMessage;
            if (this.jmsMessage != null) {
                copyMessageId = false;
            }
        }
        if (copyMessageId) {
            this.setMessageId(that.getMessageId());
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
        this.setBody(that.getBody());
        if (that.hasHeaders()) {
            this.getHeaders().putAll(that.getHeaders());
        }
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = (JmsBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), JmsBinding.class);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public javax.jms.Message getJmsMessage() {
        return this.jmsMessage;
    }

    public void setJmsMessage(javax.jms.Message jmsMessage) {
        if (jmsMessage != null) {
            try {
                this.setMessageId(jmsMessage.getJMSMessageID());
            }
            catch (JMSException e) {
                LOG.warn("Unable to retrieve JMSMessageID from JMS Message", (Throwable)e);
            }
        }
        this.jmsMessage = jmsMessage;
    }

    public Session getJmsSession() {
        return this.jmsSession;
    }

    public void setJmsSession(Session jmsSession) {
        this.jmsSession = jmsSession;
    }

    public void setBody(Object body) {
        super.setBody(body);
        if (body == null) {
            this.ensureInitialHeaders();
            this.jmsMessage = null;
        }
    }

    public Object getHeader(String name) {
        Object answer = null;
        if (this.jmsMessage != null && !this.hasPopulatedHeaders() && !name.startsWith("JMS")) {
            try {
                answer = this.getBinding().getObjectProperty(this.jmsMessage, name);
            }
            catch (JMSException e) {
                throw new RuntimeExchangeException("Unable to retrieve header from JMS Message: " + name, this.getExchange(), (Throwable)e);
            }
        }
        if (answer == null && (this.hasPopulatedHeaders() || name.startsWith("JMS"))) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    public Map<String, Object> getHeaders() {
        this.ensureInitialHeaders();
        return super.getHeaders();
    }

    public Object removeHeader(String name) {
        this.ensureInitialHeaders();
        return super.removeHeader(name);
    }

    public void setHeaders(Map<String, Object> headers) {
        this.ensureInitialHeaders();
        super.setHeaders(headers);
    }

    public void setHeader(String name, Object value) {
        this.ensureInitialHeaders();
        super.setHeader(name, value);
    }

    public SjmsMessage newInstance() {
        SjmsMessage answer = new SjmsMessage(null, null, null, this.binding);
        answer.setCamelContext(this.getCamelContext());
        return answer;
    }

    public boolean shouldCreateNewMessage() {
        return super.hasPopulatedHeaders();
    }

    protected void ensureInitialHeaders() {
        if (this.jmsMessage != null && !this.hasPopulatedHeaders()) {
            super.setHeaders(this.createHeaders());
        }
    }

    protected Object createBody() {
        if (this.jmsMessage != null) {
            return this.getBinding().extractBodyFromJms(this.getExchange(), this.jmsMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.jmsMessage != null && map != null) {
            map.putAll(this.getBinding().extractHeadersFromJms(this.jmsMessage, this.getExchange()));
            try {
                map.put("CamelMessageTimestamp", this.jmsMessage.getJMSTimestamp());
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    protected String createMessageId() {
        if (this.jmsMessage == null) {
            LOG.trace("No javax.jms.Message set so generating a new message id");
            return super.createMessageId();
        }
        try {
            String id = this.getDestinationAsString(this.jmsMessage.getJMSDestination());
            id = id != null ? id + this.jmsMessage.getJMSMessageID() : this.jmsMessage.getJMSMessageID();
            return this.getSanitizedString(id);
        }
        catch (JMSException e) {
            throw new RuntimeExchangeException("Unable to retrieve JMSMessageID from JMS Message", this.getExchange(), (Throwable)e);
        }
    }

    protected Boolean isTransactedRedelivered() {
        if (this.jmsMessage != null) {
            return JmsMessageHelper.getJMSRedelivered(this.jmsMessage);
        }
        return null;
    }

    private String getDestinationAsString(Destination destination) throws JMSException {
        String result = null;
        if (destination == null) {
            result = "null destination!" + File.separator;
        } else if (destination instanceof Topic) {
            result = "topic" + File.separator + ((Topic)destination).getTopicName() + File.separator;
        } else if (destination instanceof Queue) {
            result = "queue" + File.separator + ((Queue)destination).getQueueName() + File.separator;
        }
        return result;
    }

    private String getSanitizedString(Object value) {
        return value != null ? value.toString().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_") : "";
    }
}

