/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.util.ObjectHelper;

public class Jms11ObjectFactory
implements JmsObjectFactory {
    @Override
    public MessageConsumer createMessageConsumer(Session session, Endpoint endpoint) throws Exception {
        SjmsEndpoint sjmsEndpoint = (SjmsEndpoint)endpoint;
        Destination destination = sjmsEndpoint.getDestinationCreationStrategy().createDestination(session, sjmsEndpoint.getDestinationName(), sjmsEndpoint.isTopic());
        return this.createMessageConsumer(session, destination, sjmsEndpoint.getMessageSelector(), sjmsEndpoint.isTopic(), sjmsEndpoint.getDurableSubscriptionName(), true, false);
    }

    @Override
    public MessageConsumer createQueueMessageConsumer(Session session, Destination destination) throws Exception {
        return this.createMessageConsumer(session, destination, null, false, null, false, false);
    }

    @Override
    public MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String subscriptionName, boolean durable, boolean shared) throws Exception {
        return this.createMessageConsumer(session, destination, messageSelector, topic, subscriptionName, durable, shared, false);
    }

    @Override
    public MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String subscriptionName, boolean durable, boolean shared, boolean noLocal) throws Exception {
        Object messageConsumer = topic ? (ObjectHelper.isNotEmpty((Object)subscriptionName) ? (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createDurableSubscriber((Topic)destination, subscriptionName, messageSelector, noLocal) : session.createDurableSubscriber((Topic)destination, subscriptionName)) : (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createConsumer(destination, messageSelector, noLocal) : session.createConsumer(destination))) : (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createConsumer(destination, messageSelector) : session.createConsumer(destination));
        return messageConsumer;
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Endpoint endpoint) throws Exception {
        SjmsEndpoint sjmsEndpoint = (SjmsEndpoint)endpoint;
        return this.createMessageProducer(session, endpoint, sjmsEndpoint.getDestinationName());
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Endpoint endpoint, String destinationName) throws Exception {
        SjmsEndpoint sjmsEndpoint = (SjmsEndpoint)endpoint;
        Destination destination = sjmsEndpoint.getDestinationCreationStrategy().createDestination(session, destinationName, sjmsEndpoint.isTopic());
        boolean persistent = sjmsEndpoint.isDeliveryPersistent();
        if (sjmsEndpoint.getDeliveryMode() != null) {
            persistent = 2 == sjmsEndpoint.getDeliveryMode();
        }
        return this.createMessageProducer(session, destination, persistent, sjmsEndpoint.getTimeToLive());
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Endpoint endpoint, Destination destination) throws Exception {
        SjmsEndpoint sjmsEndpoint = (SjmsEndpoint)endpoint;
        boolean persistent = sjmsEndpoint.isDeliveryPersistent();
        if (sjmsEndpoint.getDeliveryMode() != null) {
            persistent = 2 == sjmsEndpoint.getDeliveryMode();
        }
        return this.createMessageProducer(session, destination, persistent, sjmsEndpoint.getTimeToLive());
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Destination destination, boolean persistent, long ttl) throws Exception {
        MessageProducer messageProducer = session.createProducer(destination);
        messageProducer.setDeliveryMode(persistent ? 2 : 1);
        if (ttl > 0L) {
            messageProducer.setTimeToLive(ttl);
        }
        return messageProducer;
    }
}

