/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.reply;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.camel.CamelContext;
import org.apache.camel.component.sjms.MessageListenerContainer;
import org.apache.camel.component.sjms.ReplyToType;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.reply.ExclusiveQueueMessageListenerContainer;
import org.apache.camel.component.sjms.reply.ReplyHandler;
import org.apache.camel.component.sjms.reply.ReplyManagerSupport;

public class QueueReplyManager
extends ReplyManagerSupport {
    public QueueReplyManager(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationId);
        if (handler == null) {
            return;
        }
        this.correlation.put(newCorrelationId, handler, requestTimeout);
    }

    @Override
    protected void handleReplyMessage(String correlationID, Message message, Session session) {
        ReplyHandler handler = (ReplyHandler)this.correlation.get(correlationID);
        if (handler != null) {
            this.correlation.remove(correlationID);
            handler.onReply(correlationID, message, session);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}] on reply destination [{}]. Current correlation map size: {}. The message will be ignored: {}", new Object[]{correlationID, this.replyTo, this.correlation.size(), message});
        }
    }

    @Override
    protected MessageListenerContainer createListenerContainer() throws Exception {
        ReplyToType type = this.endpoint.getReplyToType();
        if (type == null) {
            type = ReplyToType.Exclusive;
        }
        if (ReplyToType.Exclusive != type) {
            throw new IllegalArgumentException("ReplyToType " + (Object)((Object)type) + " is not supported for reply queues");
        }
        ExclusiveQueueMessageListenerContainer answer = new ExclusiveQueueMessageListenerContainer(this.endpoint);
        this.log.debug("Using exclusive queue: {} as reply listener: {}", (Object)this.endpoint.getReplyTo(), (Object)answer);
        answer.setMessageListener(this);
        answer.setConcurrentConsumers(this.endpoint.getReplyToConcurrentConsumers());
        answer.setDestinationCreationStrategy(new DestinationResolverDelegate(this.endpoint.getDestinationCreationStrategy()));
        answer.setDestinationName(this.endpoint.getReplyTo());
        String clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = clientId + ".CamelReplyManager";
            answer.setClientId(clientId);
        }
        return answer;
    }

    private final class DestinationResolverDelegate
    implements DestinationCreationStrategy {
        private final DestinationCreationStrategy delegate;
        private Destination destination;

        DestinationResolverDelegate(DestinationCreationStrategy delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Destination createDestination(Session session, String destinationName, boolean topic) throws JMSException {
            QueueReplyManager queueReplyManager = QueueReplyManager.this;
            synchronized (queueReplyManager) {
                if (this.destination == null) {
                    this.destination = this.delegate.createDestination(session, destinationName, topic);
                    QueueReplyManager.this.setReplyTo(this.destination);
                }
            }
            return this.destination;
        }

        @Override
        public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
            return null;
        }
    }
}

