/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.spi.annotations.SendDynamic;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

@SendDynamic(value="sjms")
public class SjmsSendDynamicAware
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private String scheme;

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isLenientProperties() {
        return false;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, null, null);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String originalDestination;
        String destination = this.parseDestinationName(entry.getUri());
        if (destination != null && !destination.equals(originalDestination = this.parseDestinationName(entry.getOriginalUri()))) {
            String answer = entry.getUri();
            answer = StringHelper.replaceFirst((String)answer, (String)destination, (String)originalDestination);
            return answer;
        }
        return null;
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        if (exchange.getMessage().getHeader("CamelJMSDestinationName") != null) {
            return null;
        }
        final String destinationName = this.parseDestinationName(entry.getUri());
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getMessage().setHeader("CamelJMSDestinationName", (Object)destinationName);
            }
        };
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    private String parseDestinationName(String uri) {
        int pos = (uri = uri.replaceFirst(this.scheme + "://", ":")).indexOf(63);
        if (pos != -1) {
            uri = uri.substring(0, pos);
        }
        if ((pos = uri.lastIndexOf(58)) != -1) {
            return uri.substring(pos + 1);
        }
        return null;
    }
}

