/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.slack.SlackEndpoint;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;

public class SlackProducer
extends DefaultProducer {
    private SlackEndpoint slackEndpoint;

    public SlackProducer(SlackEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.slackEndpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(this.slackEndpoint.getWebhookUrl());
        SlackMessage slackMessage = new SlackMessage();
        slackMessage.setText((String)exchange.getIn().getBody(String.class));
        slackMessage.setChannel(this.slackEndpoint.getChannel());
        slackMessage.setUsername(this.slackEndpoint.getUsername());
        slackMessage.setIconUrl(this.slackEndpoint.getIconUrl());
        slackMessage.setIconEmoji(this.slackEndpoint.getIconEmoji());
        String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)true);
        String json = this.asJson(slackMessage);
        StringEntity body = new StringEntity(json, charset);
        httpPost.setEntity((HttpEntity)body);
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
            throw new CamelExchangeException("Error POSTing to Slack API: " + response.toString(), exchange);
        }
    }

    public String asJson(SlackMessage message) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("text", message.getText());
        jsonMap.put("channel", message.getChannel());
        jsonMap.put("username", message.getUsername());
        jsonMap.put("icon_url", message.getIconUrl());
        jsonMap.put("icon_emoji", message.getIconEmoji());
        JSONObject jsonObject = new JSONObject(jsonMap);
        return JSONObject.toJSONString((Map)jsonObject);
    }
}

