/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.slack.SlackComponent;
import org.apache.camel.component.slack.SlackProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="slack", title="Slack", syntax="slack:channel", producerOnly=true, label="social")
public class SlackEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private String channel;
    @UriParam
    private String webhookUrl;
    @UriParam
    private String username;
    @UriParam
    private String iconUrl;
    @UriParam
    private String iconEmoji;

    public SlackEndpoint(String uri, String channelName, SlackComponent component) {
        super(uri, (Component)component);
        this.webhookUrl = component.getWebhookUrl();
        this.channel = channelName;
    }

    public Producer createProducer() throws Exception {
        SlackProducer producer = new SlackProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume slack messages from this endpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public void setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
    }
}

