/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.slack.SlackEndpoint;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;

public class SlackProducer
extends DefaultProducer {
    private SlackEndpoint slackEndpoint;

    public SlackProducer(SlackEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.slackEndpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        SlackMessage slackMessage;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(this.slackEndpoint.getWebhookUrl());
        Object payload = exchange.getIn().getBody();
        if (payload instanceof SlackMessage) {
            slackMessage = (SlackMessage)payload;
        } else {
            slackMessage = new SlackMessage();
            slackMessage.setText((String)exchange.getIn().getBody(String.class));
        }
        slackMessage.setChannel(this.slackEndpoint.getChannel());
        slackMessage.setUsername(this.slackEndpoint.getUsername());
        slackMessage.setIconUrl(this.slackEndpoint.getIconUrl());
        slackMessage.setIconEmoji(this.slackEndpoint.getIconEmoji());
        String charset = IOHelper.getCharsetName((Exchange)exchange, (boolean)true);
        String json = this.asJson(slackMessage);
        StringEntity body = new StringEntity(json, charset);
        httpPost.setEntity((HttpEntity)body);
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
            throw new CamelExchangeException("Error POSTing to Slack API: " + response.toString(), exchange);
        }
    }

    public String asJson(SlackMessage message) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("text", message.getText());
        jsonMap.put("channel", message.getChannel());
        jsonMap.put("username", message.getUsername());
        jsonMap.put("icon_url", message.getIconUrl());
        jsonMap.put("icon_emoji", message.getIconEmoji());
        List<SlackMessage.Attachment> attachments = message.getAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            this.buildAttachmentJson(jsonMap, attachments);
        }
        JSONObject jsonObject = new JSONObject(jsonMap);
        return JSONObject.toJSONString((Map)jsonObject);
    }

    private void buildAttachmentJson(Map<String, Object> jsonMap, List<SlackMessage.Attachment> attachments) {
        ArrayList attachmentsJson = new ArrayList(attachments.size());
        attachments.forEach(attachment -> {
            HashMap<String, Object> attachmentJson = new HashMap<String, Object>();
            attachmentJson.put("fallback", attachment.getFallback());
            attachmentJson.put("color", attachment.getColor());
            attachmentJson.put("pretext", attachment.getPretext());
            attachmentJson.put("author_name", attachment.getAuthorName());
            attachmentJson.put("author_link", attachment.getAuthorLink());
            attachmentJson.put("author_icon", attachment.getAuthorIcon());
            attachmentJson.put("title", attachment.getTitle());
            attachmentJson.put("title_link", attachment.getTitleLink());
            attachmentJson.put("text", attachment.getText());
            attachmentJson.put("image_url", attachment.getImageUrl());
            attachmentJson.put("footer", attachment.getFooter());
            attachmentJson.put("footer_icon", attachment.getFooterIcon());
            attachmentJson.put("ts", attachment.getTs());
            List<SlackMessage.Attachment.Field> fields = attachment.getFields();
            if (fields != null && !fields.isEmpty()) {
                this.buildAttachmentFieldJson(attachmentJson, fields);
            }
            attachmentsJson.add(attachmentJson);
        });
        jsonMap.put("attachments", attachmentsJson);
    }

    private void buildAttachmentFieldJson(Map<String, Object> attachmentJson, List<SlackMessage.Attachment.Field> fields) {
        ArrayList fieldsJson = new ArrayList(fields.size());
        fields.forEach(field -> {
            HashMap<String, Object> fieldJson = new HashMap<String, Object>();
            fieldJson.put("title", field.getTitle());
            fieldJson.put("value", field.getValue());
            fieldJson.put("short", field.isShortValue());
            fieldsJson.add(fieldJson);
        });
        attachmentJson.put("fields", fieldsJson);
    }
}

