/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.smbj.share.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;

public class SmbFile
implements WrappedFile<File> {
    private final File file;

    public SmbFile(File file) {
        this.file = file;
    }

    void populateHeaders(Exchange exchange) {
        exchange.getMessage().setHeader("CamelSmbFilePath", (Object)this.file.getPath());
        exchange.getMessage().setHeader("CamelSmbUncPath", (Object)this.file.getUncPath());
        exchange.getMessage().setHeader("CamelFileName", (Object)this.file.getFileInformation().getNameInformation().toString());
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.getFile().getPath();
    }

    public String getUncPath() {
        return this.getFile().getUncPath();
    }

    public InputStream getInputStream() {
        return this.getFile().getInputStream();
    }

    public long getSize() {
        return this.file.getFileInformation().getStandardInformation().getEndOfFile();
    }

    public Object getBody() {
        byte[] byArray;
        block8: {
            InputStream is = this.file.getInputStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return byArray;
    }
}

