/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpActionType;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.component.snmp.SnmpHelper;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class SnmpOIDPoller
extends ScheduledPollConsumer
implements ResponseListener {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpOIDPoller.class);
    private Address targetAddress;
    private TransportMapping<? extends Address> transport;
    private Snmp snmp;
    private Target target;
    private PDU pdu;
    private SnmpEndpoint endpoint;

    public SnmpOIDPoller(SnmpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.targetAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        if ("tcp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultTcpTransportMapping();
        } else if ("udp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultUdpTransportMapping();
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
        }
        this.snmp = new Snmp(this.transport);
        SnmpHelper.createAndSetUSM(this.endpoint);
        this.pdu = SnmpHelper.createPDU(this.endpoint);
        this.target = SnmpHelper.createTarget(this.endpoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting OID poller on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
        this.transport.listen();
        if (LOG.isInfoEnabled()) {
            LOG.info("Started OID poller on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
    }

    protected void doStop() throws Exception {
        if (this.transport != null && this.transport.isListening()) {
            LOG.info("Stopping OID poller on {}", (Object)this.targetAddress);
            this.transport.close();
            LOG.info("Stopped OID poller on {}", (Object)this.targetAddress);
        }
        super.doStop();
    }

    protected int poll() throws Exception {
        this.pdu.clear();
        int type = this.getPduType(this.endpoint.getType());
        this.pdu.setType(type);
        if (!this.endpoint.isTreeList()) {
            for (OID oid : this.endpoint.getOids()) {
                this.pdu.add(new VariableBinding(oid));
            }
        } else {
            TreeUtils treeUtils = new TreeUtils((Session)this.snmp, (PDUFactory)new DefaultPDUFactory());
            for (OID oid : this.endpoint.getOids()) {
                List events = treeUtils.getSubtree(this.target, new OID(oid));
                for (Object eventObj : events) {
                    TreeEvent event = (TreeEvent)eventObj;
                    if (event == null) {
                        LOG.warn("Event is null");
                        continue;
                    }
                    if (event.isError()) {
                        LOG.error("Error in event: {}", (Object)event.getErrorMessage());
                        continue;
                    }
                    VariableBinding[] varBindings = event.getVariableBindings();
                    if (varBindings == null || varBindings.length == 0) continue;
                    for (VariableBinding varBinding : varBindings) {
                        if (varBinding == null) continue;
                        this.pdu.add(varBinding);
                    }
                }
            }
        }
        this.snmp.send(this.pdu, this.target, null, (ResponseListener)this);
        return 1;
    }

    public void onResponse(ResponseEvent event) {
        ((Snmp)event.getSource()).cancel(event.getRequest(), (ResponseListener)this);
        if (event.getRequest() == null || event.getResponse() == null) {
            LOG.debug("Received invalid SNMP event. Request: {} / Response: {}", (Object)event.getRequest(), (Object)event.getResponse());
            return;
        }
        PDU pdu = event.getResponse();
        this.processPDU(pdu);
    }

    public void processPDU(PDU pdu) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received response event for {} : {}", (Object)this.endpoint.getAddress(), (Object)pdu);
        }
        Exchange exchange = this.endpoint.createExchange(pdu);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }

    private int getPduType(SnmpActionType type) {
        if (SnmpActionType.GET_NEXT == type) {
            return -95;
        }
        return -96;
    }
}

