/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.snmp.OIDList;
import org.apache.camel.component.snmp.SnmpActionType;
import org.apache.camel.component.snmp.SnmpComponent;
import org.apache.camel.component.snmp.SnmpMessage;
import org.apache.camel.component.snmp.SnmpOIDPoller;
import org.apache.camel.component.snmp.SnmpProducer;
import org.apache.camel.component.snmp.SnmpTrapConsumer;
import org.apache.camel.component.snmp.SnmpTrapProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultPollingEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;

@UriEndpoint(firstVersion="2.1.0", scheme="snmp", title="SNMP", syntax="snmp:host:port", category={Category.MONITORING})
public class SnmpEndpoint
extends DefaultPollingEndpoint {
    public static final String DEFAULT_COMMUNITY = "public";
    public static final int DEFAULT_SNMP_VERSION = 0;
    public static final int DEFAULT_SNMP_RETRIES = 2;
    public static final int DEFAULT_SNMP_TIMEOUT = 1500;
    private static final Logger LOG = LoggerFactory.getLogger(SnmpEndpoint.class);
    private transient String address;
    @UriPath(description="Hostname of the SNMP enabled device")
    @Metadata(required=true)
    private String host;
    @UriPath(description="Port number of the SNMP enabled device")
    @Metadata(required=true)
    private Integer port;
    @UriParam(defaultValue="udp", enums="tcp,udp")
    private String protocol = "udp";
    @UriParam(defaultValue="2")
    private int retries = 2;
    @UriParam(defaultValue="1500")
    private int timeout = 1500;
    @UriParam(defaultValue="0", enums="0,1,3")
    private int snmpVersion = 0;
    @UriParam(defaultValue="public")
    private String snmpCommunity = "public";
    @UriParam
    private SnmpActionType type;
    @UriParam(label="consumer", defaultValue="60000", javaType="java.time.Duration", description="Milliseconds before the next poll.")
    private long delay = 60000L;
    @UriParam(defaultValue="3", enums="1,2,3", label="security")
    private int securityLevel = 3;
    @UriParam(label="security", secret=true)
    private String securityName;
    @UriParam(enums="MD5,SHA1", label="security")
    private String authenticationProtocol;
    @UriParam(label="security", secret=true)
    private String authenticationPassphrase;
    @UriParam(label="security", secret=true)
    private String privacyProtocol;
    @UriParam(label="security", secret=true)
    private String privacyPassphrase;
    @UriParam
    private String snmpContextName;
    @UriParam
    private String snmpContextEngineId;
    @UriParam
    private OIDList oids = new OIDList();
    @UriParam(label="consumer", defaultValue="false")
    private boolean treeList;

    public SnmpEndpoint(String uri, SnmpComponent component) {
        super(uri, (Component)component);
        super.setDelay(60000L);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.type == SnmpActionType.TRAP) {
            return new SnmpTrapConsumer(this, processor);
        }
        if (this.type == SnmpActionType.POLL) {
            SnmpOIDPoller answer = new SnmpOIDPoller(this, processor);
            this.configureConsumer((Consumer)answer);
            return answer;
        }
        throw new IllegalArgumentException("The type '" + this.type + "' is not valid!");
    }

    public Producer createProducer() throws Exception {
        if (this.type == SnmpActionType.TRAP) {
            return new SnmpTrapProducer(this);
        }
        return new SnmpProducer(this, this.type);
    }

    public Exchange createExchange(PDU pdu) {
        Exchange exchange = super.createExchange();
        exchange.setIn((Message)new SnmpMessage(this.getCamelContext(), pdu));
        return exchange;
    }

    @Deprecated
    public void initiate() throws Exception {
    }

    public SnmpActionType getType() {
        return this.type;
    }

    public void setType(SnmpActionType type) {
        this.type = type;
    }

    public OIDList getOids() {
        return this.oids;
    }

    public void setOids(OIDList oids) {
        this.oids = oids;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setSnmpVersion(int snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    protected void doInit() throws Exception {
        super.doInit();
        URI uri = URI.create(this.getEndpointUri());
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || host.trim().length() < 1) {
            host = "127.0.0.1";
        }
        if (port == -1) {
            port = this.getType() == SnmpActionType.POLL ? 161 : 162;
        }
        String address = String.format("%s:%s/%d", this.getProtocol(), host, port);
        LOG.debug("Using snmp address {}", (Object)address);
        this.setAddress(address);
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setAuthenticationProtocol(String authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public String getAuthenticationPassphrase() {
        return this.authenticationPassphrase;
    }

    public void setAuthenticationPassphrase(String authenticationPassphrase) {
        this.authenticationPassphrase = authenticationPassphrase;
    }

    public String getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public String getPrivacyPassphrase() {
        return this.privacyPassphrase;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this.privacyPassphrase = privacyPassphrase;
    }

    public String getSnmpContextName() {
        return this.snmpContextName;
    }

    public void setSnmpContextName(String snmpContextName) {
        this.snmpContextName = snmpContextName;
    }

    public String getSnmpContextEngineId() {
        return this.snmpContextEngineId;
    }

    public void setSnmpContextEngineId(String snmpContextEngineId) {
        this.snmpContextEngineId = snmpContextEngineId;
    }

    public boolean isTreeList() {
        return this.treeList;
    }

    public void setTreeList(boolean treeList) {
        this.treeList = treeList;
    }

    public String toString() {
        return "snmp://" + this.address;
    }
}

