/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.snmp.SnmpActionType;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.component.snmp.SnmpHelper;
import org.apache.camel.component.snmp.SnmpMessage;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpProducer.class);
    private SnmpEndpoint endpoint;
    private Address targetAddress;
    private USM usm;
    private Target target;
    private SnmpActionType actionType;
    private PDU pdu;

    public SnmpProducer(SnmpEndpoint endpoint, SnmpActionType actionType) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.actionType = actionType;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.targetAddress = GenericAddress.parse((String)this.endpoint.getServerAddress());
        LOG.debug("targetAddress: {}", (Object)this.targetAddress);
        this.usm = SnmpHelper.createAndSetUSM(this.endpoint);
        this.pdu = SnmpHelper.createPDU(this.endpoint);
        this.target = SnmpHelper.createTarget(this.endpoint);
        if (this.actionType == SnmpActionType.POLL) {
            for (OID oid : this.endpoint.getOids()) {
                this.pdu.add(new VariableBinding(oid));
            }
        }
        this.pdu.setErrorIndex(0);
        this.pdu.setErrorStatus(0);
        if (this.endpoint.getSnmpVersion() > 0) {
            this.pdu.setMaxRepetitions(0);
        }
        if (this.actionType == SnmpActionType.GET_NEXT) {
            this.pdu.setType(-95);
        } else {
            this.pdu.setType(-96);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            if (this.usm != null) {
                SecurityModels.getInstance().removeSecurityModel(new Integer32(this.usm.getID()));
            }
        }
        finally {
            this.targetAddress = null;
            this.usm = null;
            this.target = null;
            this.pdu = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block20: {
            Snmp snmp = null;
            DefaultTcpTransportMapping transport = null;
            try {
                LOG.debug("Starting SNMP producer on {}", (Object)this.endpoint.getServerAddress());
                if ("tcp".equals(this.endpoint.getProtocol())) {
                    transport = new DefaultTcpTransportMapping();
                } else if ("udp".equals(this.endpoint.getProtocol())) {
                    transport = new DefaultUdpTransportMapping();
                } else {
                    throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
                }
                snmp = new Snmp((TransportMapping)transport);
                LOG.debug("Snmp: i am sending");
                snmp.listen();
                if (this.actionType == SnmpActionType.GET_NEXT) {
                    ArrayList<SnmpMessage> smLst = new ArrayList<SnmpMessage>();
                    block11: for (OID oid : this.endpoint.getOids()) {
                        ResponseEvent responseEvent;
                        this.pdu.clear();
                        this.pdu.add(new VariableBinding(oid));
                        boolean matched = true;
                        while (matched && (responseEvent = snmp.send(this.pdu, this.target)) != null && responseEvent.getResponse() != null) {
                            PDU response = responseEvent.getResponse();
                            String nextOid = null;
                            List variableBindings = response.getVariableBindings();
                            for (int i = 0; i < variableBindings.size(); ++i) {
                                VariableBinding variableBinding = (VariableBinding)variableBindings.get(i);
                                nextOid = variableBinding.getOid().toDottedString();
                                if (nextOid.startsWith(oid.toDottedString())) continue;
                                matched = false;
                                break;
                            }
                            if (!matched) continue block11;
                            this.pdu.clear();
                            this.pdu.add(new VariableBinding(new OID(nextOid)));
                            smLst.add(new SnmpMessage(this.getEndpoint().getCamelContext(), response));
                        }
                    }
                    exchange.getIn().setBody(smLst);
                    break block20;
                }
                ResponseEvent responseEvent = snmp.send(this.pdu, this.target);
                LOG.debug("Snmp: sended");
                if (responseEvent.getResponse() != null) {
                    exchange.getIn().setBody((Object)new SnmpMessage(this.getEndpoint().getCamelContext(), responseEvent.getResponse()));
                    break block20;
                }
                throw new TimeoutException("SNMP Producer Timeout");
            }
            finally {
                try {
                    transport.close();
                }
                catch (Exception exception) {}
                try {
                    snmp.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

