/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.MethodInfo;
import org.apache.camel.dataformat.soap.name.TypeInfo;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInterfaceStrategy
implements ElementNameStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInterfaceStrategy.class);
    private Map<String, MethodInfo> soapActionToMethodInfo = new HashMap<String, MethodInfo>();
    private Map<String, QName> inTypeNameToQName = new HashMap<String, QName>();
    private Map<String, QName> outTypeNameToQName = new HashMap<String, QName>();
    private boolean isClient;
    private ElementNameStrategy fallBackStrategy;
    private Map<QName, Class<? extends Exception>> faultNameToException = new HashMap<QName, Class<? extends Exception>>();

    public ServiceInterfaceStrategy(Class<?> serviceInterface, boolean isClient) {
        this.analyzeServiceInterface(serviceInterface);
        this.isClient = isClient;
        this.fallBackStrategy = new TypeNameStrategy();
    }

    public String getMethodForSoapAction(String soapAction) {
        MethodInfo methodInfo = this.soapActionToMethodInfo.get(soapAction);
        return methodInfo == null ? null : methodInfo.getName();
    }

    private TypeInfo getOutInfo(Method method) {
        ResponseWrapper respWrap = method.getAnnotation(ResponseWrapper.class);
        if (respWrap != null && respWrap.className() != null) {
            return new TypeInfo(respWrap.className(), new QName(respWrap.targetNamespace(), respWrap.localName()));
        }
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.equals(returnType)) {
            return new TypeInfo(null, null);
        }
        Class<?> type = method.getReturnType();
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            return new TypeInfo(type.getName(), new QName(webResult.targetNamespace(), webResult.name()));
        }
        throw new IllegalArgumentException("Result type of method " + method.getName() + " is not annotated with WebResult. This is not yet supported");
    }

    private List<TypeInfo> getInInfo(Method method) {
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        RequestWrapper requestWrapper = method.getAnnotation(RequestWrapper.class);
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return typeInfos;
        }
        if (requestWrapper != null && requestWrapper.className() != null) {
            typeInfos.add(new TypeInfo(requestWrapper.className(), new QName(requestWrapper.targetNamespace(), requestWrapper.localName())));
            return typeInfos;
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        ArrayList<WebParam> webParams = new ArrayList<WebParam>();
        Annotation[][] annotationArray = annotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] singleParameterAnnotations;
            for (Annotation annotation : singleParameterAnnotations = annotationArray[i]) {
                if (!(annotation instanceof WebParam)) continue;
                webParams.add((WebParam)annotation);
            }
        }
        if (webParams.size() != types.length) {
            throw new IllegalArgumentException("The number of @WebParam annotations for Method " + method.getName() + " does not match the number of parameters. This is not supported.");
        }
        Iterator webParamIter = webParams.iterator();
        int paramCounter = -1;
        while (webParamIter.hasNext()) {
            WebParam webParam = (WebParam)webParamIter.next();
            typeInfos.add(new TypeInfo(types[++paramCounter].getName(), new QName(webParam.targetNamespace(), webParam.name())));
        }
        return typeInfos;
    }

    private MethodInfo analyzeMethod(Method method) {
        List<TypeInfo> inInfos = this.getInInfo(method);
        TypeInfo outInfo = this.getOutInfo(method);
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        String soapAction = webMethod != null ? webMethod.action() : null;
        return new MethodInfo(method.getName(), soapAction, inInfos.toArray(new TypeInfo[inInfos.size()]), outInfo);
    }

    private void analyzeServiceInterface(Class<?> serviceInterface) {
        Method[] methods;
        for (Method method : methods = serviceInterface.getMethods()) {
            MethodInfo info = this.analyzeMethod(method);
            for (int i = 0; i < info.getIn().length; ++i) {
                TypeInfo ti = info.getIn()[i];
                if (this.inTypeNameToQName.containsKey(ti.getTypeName()) && ti.getTypeName() != null && !ti.getTypeName().equals("javax.xml.ws.Holder") && !this.inTypeNameToQName.get(ti.getTypeName()).equals(ti.getElName())) {
                    LOG.warn("Ambiguous QName mapping. The type [{}] is already mapped to a QName in this context.", (Object)ti.getTypeName());
                    continue;
                }
                this.inTypeNameToQName.put(ti.getTypeName(), ti.getElName());
            }
            if (info.getSoapAction() != null && !"".equals(info.getSoapAction())) {
                this.soapActionToMethodInfo.put(info.getSoapAction(), info);
            }
            this.outTypeNameToQName.put(info.getOut().getTypeName(), info.getOut().getElName());
            this.addExceptions(method);
        }
    }

    private void addExceptions(Method method) {
        Class<?>[] exTypes;
        for (Class<?> exType : exTypes = method.getExceptionTypes()) {
            WebFault webFault = exType.getAnnotation(WebFault.class);
            if (webFault == null) continue;
            QName faultName = new QName(webFault.targetNamespace(), webFault.name());
            this.faultNameToException.put(faultName, exType);
        }
    }

    @Override
    public QName findQNameForSoapActionOrType(String soapAction, Class<?> type) {
        MethodInfo info = this.soapActionToMethodInfo.get(soapAction);
        if (info != null) {
            if (this.isClient) {
                if (type != null) {
                    return info.getIn(type.getName()).getElName();
                }
                return null;
            }
            return info.getOut().getElName();
        }
        QName qName = null;
        if (type != null) {
            qName = this.isClient ? this.inTypeNameToQName.get(type.getName()) : this.outTypeNameToQName.get(type.getName());
        }
        if (qName == null) {
            try {
                qName = this.fallBackStrategy.findQNameForSoapActionOrType(soapAction, type);
            }
            catch (Exception e) {
                String msg = "No method found that matches the given SoapAction " + soapAction + " or that has an " + (this.isClient ? "input" : "output") + " of type " + type.getName();
                throw new RuntimeCamelException(msg, (Throwable)e);
            }
        }
        return qName;
    }

    @Override
    public Class<? extends Exception> findExceptionForFaultName(QName faultName) {
        return this.faultNameToException.get(faultName);
    }
}

