/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.ws.Holder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.dataformat.soap.Soap11DataFormatAdapter;
import org.apache.camel.dataformat.soap.Soap12DataFormatAdapter;
import org.apache.camel.dataformat.soap.SoapDataFormatAdapter;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.ServiceInterfaceStrategy;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.apache.camel.spi.annotations.Dataformat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="soap")
public class SoapDataFormat
extends JaxbDataFormat {
    public static final String SOAP_UNMARSHALLED_HEADER_LIST = "org.apache.camel.dataformat.soap.UNMARSHALLED_HEADER_LIST";
    private static final Logger LOG = LoggerFactory.getLogger(SoapDataFormat.class);
    private SoapDataFormatAdapter adapter;
    private ElementNameStrategy elementNameStrategy = new TypeNameStrategy();
    private boolean ignoreUnmarshalledHeaders;
    private String version;

    public SoapDataFormat() {
    }

    public SoapDataFormat(String contextPath) {
        super(contextPath);
    }

    public SoapDataFormat(String contextPath, ElementNameStrategy elementNameStrategy) {
        this(contextPath);
        this.elementNameStrategy = elementNameStrategy;
    }

    public String getDataFormatName() {
        return "soap";
    }

    protected void doStart() throws Exception {
        if ("1.2".equals(this.version)) {
            LOG.debug("Using SOAP 1.2 adapter");
            this.adapter = new Soap12DataFormatAdapter(this);
        } else {
            LOG.debug("Using SOAP 1.1 adapter");
            this.adapter = new Soap11DataFormatAdapter(this);
        }
        super.doStart();
    }

    public void marshal(Exchange exchange, Object inputObject, OutputStream stream) throws IOException {
        String soapAction = this.getSoapActionFromExchange(exchange);
        Object envelope = this.adapter.doMarshal(exchange, inputObject, stream, soapAction);
        super.marshal(exchange, envelope, stream);
    }

    protected List<Object> createContentFromObject(Object inputObject, String soapAction) {
        ArrayList<Object> bodyParts = new ArrayList<Object>();
        bodyParts.add(inputObject);
        ArrayList<Object> bodyElements = new ArrayList<Object>();
        for (Object e : bodyParts) {
            QName name = this.elementNameStrategy.findQNameForSoapActionOrType(soapAction, e.getClass());
            if (name == null) {
                LOG.warn("Could not find QName for class {}", (Object)e.getClass().getName());
                continue;
            }
            bodyElements.add(this.getElement(e, name));
        }
        return bodyElements;
    }

    private JAXBElement<?> getElement(Object fromObj, QName name) {
        Object value = null;
        if (fromObj instanceof Holder) {
            Holder holder = (Holder)fromObj;
            value = holder.value;
            if (null == value) {
                return null;
            }
        } else {
            value = fromObj;
        }
        return new JAXBElement(name, value.getClass(), value);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        String soapAction = this.getSoapActionFromExchange(exchange);
        if (soapAction != null && this.elementNameStrategy instanceof ServiceInterfaceStrategy) {
            ServiceInterfaceStrategy strategy = (ServiceInterfaceStrategy)this.elementNameStrategy;
            String methodName = strategy.getMethodForSoapAction(soapAction);
            exchange.getOut().setHeader("CamelBeanMethodName", (Object)methodName);
        }
        if (soapAction != null) {
            exchange.setProperty("CamelSoapAction", (Object)soapAction);
        }
        Object unmarshalledObject = super.unmarshal(exchange, stream);
        Object rootObject = JAXBIntrospector.getValue((Object)unmarshalledObject);
        return this.adapter.doUnmarshal(exchange, stream, rootObject);
    }

    private String getSoapActionFromExchange(Exchange exchange) {
        Message inMessage = exchange.getIn();
        String soapAction = (String)inMessage.getHeader("CamelSoapAction", String.class);
        if (soapAction == null && (soapAction = (String)inMessage.getHeader("SOAPAction", String.class)) != null && soapAction.startsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        if (soapAction == null) {
            soapAction = (String)exchange.getProperty("CamelSoapAction", String.class);
        }
        return soapAction;
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.getContextPath() != null) {
            return JAXBContext.newInstance((String)(this.adapter.getSoapPackageName() + ":" + this.getContextPath()));
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }

    public ElementNameStrategy getElementNameStrategy() {
        return this.elementNameStrategy;
    }

    public void setElementNameStrategy(Object nameStrategy) {
        if (nameStrategy != null) {
            if (nameStrategy instanceof ElementNameStrategy) {
                this.elementNameStrategy = (ElementNameStrategy)nameStrategy;
            } else {
                throw new IllegalArgumentException("The argument for setElementNameStrategy should be subClass of " + ElementNameStrategy.class.getName());
            }
        }
    }

    public boolean isIgnoreUnmarshalledHeaders() {
        return this.ignoreUnmarshalledHeaders;
    }

    public void setIgnoreUnmarshalledHeaders(boolean ignoreUnmarshalledHeaders) {
        this.ignoreUnmarshalledHeaders = ignoreUnmarshalledHeaders;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

