/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.spark.RddCallback;
import org.apache.camel.util.ObjectHelper;
import org.apache.spark.api.java.JavaRDDLike;

class AnnotatedRddCallbackProxy
implements RddCallback {
    private final Object objectWithCallback;
    private final List<Method> rddCallbacks;
    private final CamelContext camelContext;

    public AnnotatedRddCallbackProxy(Object objectWithCallback, CamelContext camelContext) {
        this.objectWithCallback = objectWithCallback;
        this.camelContext = camelContext;
        this.rddCallbacks = ObjectHelper.findMethodsWithAnnotation(objectWithCallback.getClass(), org.apache.camel.component.spark.annotations.RddCallback.class);
        if (this.rddCallbacks.size() == 0) {
            throw new UnsupportedOperationException("Can't find methods annotated with @RddCallback.");
        }
    }

    public AnnotatedRddCallbackProxy(Object objectWithCallback) {
        this(objectWithCallback, null);
    }

    public Object onRdd(JavaRDDLike rdd, Object ... payloads) {
        try {
            ArrayList<Object> arguments = new ArrayList<Object>(payloads.length + 1);
            arguments.add(rdd);
            arguments.addAll(Arrays.asList(payloads));
            if (arguments.get(1) == null) {
                arguments.remove(1);
            }
            Method callbackMethod = this.rddCallbacks.get(0);
            callbackMethod.setAccessible(true);
            if (this.camelContext != null) {
                for (int i = 1; i < arguments.size(); ++i) {
                    arguments.set(i, this.camelContext.getTypeConverter().convertTo(callbackMethod.getParameterTypes()[i], arguments.get(i)));
                }
            }
            return callbackMethod.invoke(this.objectWithCallback, arguments.toArray(new Object[arguments.size()]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

