/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.spark.DataFrameCallback;
import org.apache.camel.component.spark.DataFrameSparkProducer;
import org.apache.camel.component.spark.EndpointType;
import org.apache.camel.component.spark.HiveSparkProducer;
import org.apache.camel.component.spark.RddCallback;
import org.apache.camel.component.spark.RddSparkProducer;
import org.apache.camel.component.spark.SparkComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.17.0", scheme="spark", title="Apache Spark", syntax="spark:endpointType", producerOnly=true, label="bigdata,iot")
public class SparkEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SparkEndpoint.class);
    @UriPath
    @Metadata(required="true")
    private EndpointType endpointType;
    @UriParam
    private JavaRDDLike rdd;
    @UriParam
    private RddCallback rddCallback;
    @UriParam
    private Dataset<Row> dataFrame;
    @UriParam
    private DataFrameCallback dataFrameCallback;
    @UriParam(defaultValue="true")
    private boolean collect = true;

    public SparkEndpoint(String endpointUri, SparkComponent component, EndpointType endpointType) {
        super(endpointUri, (Component)component);
        this.endpointType = endpointType;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.rdd == null) {
            this.rdd = this.getComponent().getRdd();
        }
        if (this.rddCallback == null) {
            this.rddCallback = this.getComponent().getRddCallback();
        }
    }

    public Producer createProducer() throws Exception {
        LOG.trace("Creating {} Spark producer.", (Object)this.endpointType);
        if (this.endpointType == EndpointType.rdd) {
            LOG.trace("About to create RDD producer.");
            return new RddSparkProducer(this);
        }
        if (this.endpointType == EndpointType.dataframe) {
            LOG.trace("About to create DataFrame producer.");
            return new DataFrameSparkProducer(this);
        }
        LOG.trace("About to create Hive producer.");
        return new HiveSparkProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Spark component supports producer endpoints only.");
    }

    public boolean isSingleton() {
        return true;
    }

    public SparkComponent getComponent() {
        return (SparkComponent)super.getComponent();
    }

    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
    }

    public JavaRDDLike getRdd() {
        return this.rdd;
    }

    public void setRdd(JavaRDDLike rdd) {
        this.rdd = rdd;
    }

    public RddCallback getRddCallback() {
        return this.rddCallback;
    }

    public void setRddCallback(RddCallback rddCallback) {
        this.rddCallback = rddCallback;
    }

    public Dataset<Row> getDataFrame() {
        return this.dataFrame;
    }

    public void setDataFrame(Dataset<Row> dataFrame) {
        this.dataFrame = dataFrame;
    }

    public DataFrameCallback getDataFrameCallback() {
        return this.dataFrameCallback;
    }

    public void setDataFrameCallback(DataFrameCallback dataFrameCallback) {
        this.dataFrameCallback = dataFrameCallback;
    }

    public boolean isCollect() {
        return this.collect;
    }

    public void setCollect(boolean collect) {
        this.collect = collect;
    }
}

