/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.splunkhec.SplunkHECEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

public class SplunkHECProducer
extends DefaultProducer {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private SplunkHECEndpoint endpoint;
    private CloseableHttpClient httpClient;

    public SplunkHECProducer(SplunkHECEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        HttpClientBuilder builder = HttpClients.custom().setUserAgent("Camel Splunk HEC/" + this.getEndpoint().getCamelContext().getVersion()).setMaxConnTotal(10);
        if (this.endpoint.getConfiguration().isSkipTlsVerify()) {
            SSLContextBuilder sslbuilder = new SSLContextBuilder();
            sslbuilder.loadTrustMaterial(null, (chain, authType) -> true);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslbuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        this.httpClient = builder.build();
    }

    public void process(Exchange exchange) throws Exception {
        Map<String, Object> payload = this.createPayload(exchange.getIn());
        HttpPost httppost = new HttpPost((this.endpoint.getConfiguration().isHttps() ? "https" : "http") + "://" + this.endpoint.getSplunkURL() + "/services/collector/event");
        httppost.addHeader("Authorization", " Splunk " + this.endpoint.getToken());
        EntityTemplate entityTemplate = new EntityTemplate(outputStream -> MAPPER.writer().writeValue(outputStream, (Object)payload));
        entityTemplate.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        httppost.setEntity((HttpEntity)entityTemplate);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);){
            if (response.getStatusLine().getStatusCode() != 200) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                response.getEntity().writeTo((OutputStream)output);
                throw new RuntimeException(response.getStatusLine().toString() + "\n" + new String(output.toByteArray(), StandardCharsets.UTF_8));
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    Map<String, Object> createPayload(Message message) {
        Object body = message.getBody();
        HashMap<String, Object> eventPayload = new HashMap<String, Object>();
        eventPayload.put("body", body);
        eventPayload.put("headers", message.getHeaders());
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.buildPayload(payload);
        payload.put("event", eventPayload);
        return payload;
    }

    private void buildPayload(Map<String, Object> payload) {
        if (this.endpoint.getConfiguration().getSourceType() != null) {
            payload.put("sourcetype", this.endpoint.getConfiguration().getSourceType());
        }
        if (this.endpoint.getConfiguration().getSource() != null) {
            payload.put("source", this.endpoint.getConfiguration().getSource());
        }
        if (this.endpoint.getConfiguration().getIndex() != null) {
            payload.put("index", this.endpoint.getConfiguration().getIndex());
        }
        if (this.endpoint.getConfiguration().getHost() != null) {
            payload.put("host", this.endpoint.getConfiguration().getHost());
        }
    }
}

