/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk.support;

import com.splunk.Args;
import com.splunk.Service;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.camel.component.splunk.SplunkEndpoint;
import org.apache.camel.component.splunk.event.SplunkEvent;
import org.apache.camel.component.splunk.support.DataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SplunkDataWriter
implements DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkDataWriter.class);
    protected SplunkEndpoint endpoint;
    protected Args args;
    private boolean connected;
    private Socket socket;

    public SplunkDataWriter(SplunkEndpoint endpoint, Args args) {
        this.endpoint = endpoint;
        this.args = args;
    }

    protected abstract Socket createSocket(Service var1) throws IOException;

    @Override
    public void write(SplunkEvent event) throws Exception {
        LOG.debug("writing event to splunk:" + event);
        this.doWrite(event);
    }

    protected void doWrite(SplunkEvent event) throws IOException {
        OutputStream ostream = this.socket.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(ostream, "UTF8");
        writer.write(event.toString());
        ((Writer)writer).flush();
    }

    @Override
    public synchronized void start() {
        try {
            this.socket = this.createSocket(this.endpoint.getService());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.connected = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

