/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class RoutesCollector
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesCollector.class);
    private final ApplicationContext applicationContext;
    private final List<CamelContextConfiguration> camelContextConfigurations;

    public RoutesCollector(ApplicationContext applicationContext, List<CamelContextConfiguration> camelContextConfigurations) {
        this.applicationContext = applicationContext;
        this.camelContextConfigurations = camelContextConfigurations;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        CamelContext camelContext = (CamelContext)contextRefreshedEvent.getApplicationContext().getBean(CamelContext.class);
        LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
        for (RoutesBuilder routesBuilder : this.applicationContext.getBeansOfType(RoutesBuilder.class).values()) {
            try {
                LOG.debug("Injecting following route into the CamelContext: {}", (Object)routesBuilder);
                camelContext.addRoutes(routesBuilder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.camelContextConfigurations != null) {
            for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                LOG.debug("CamelContextConfiguration found. Invoking: {}", (Object)camelContextConfiguration);
                camelContextConfiguration.beforeApplicationStart(camelContext);
            }
        }
        try {
            camelContext.start();
        }
        catch (Exception e) {
            throw new CamelSpringBootInitializationException(e);
        }
    }
}

