/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Collections;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.MainSupport;
import org.springframework.context.ApplicationContext;

public class CamelSpringBootApplicationController {
    private final MainSupport mainSupport;

    public CamelSpringBootApplicationController(final ApplicationContext applicationContext, final CamelContext camelContext) {
        this.mainSupport = new MainSupport(){

            protected ProducerTemplate findOrCreateCamelTemplate() {
                return (ProducerTemplate)applicationContext.getBean(ProducerTemplate.class);
            }

            protected Map<String, CamelContext> getCamelContextMap() {
                return Collections.singletonMap("camelContext", camelContext);
            }
        };
    }

    public void blockMainThread() {
        try {
            this.mainSupport.enableHangupSupport();
            this.mainSupport.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    private void destroy() {
        this.mainSupport.completed();
    }
}

