/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.support.TypeConverterSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;

public class SpringTypeConverter
extends TypeConverterSupport {
    private final List<ConversionService> conversionServices;

    @Autowired
    public SpringTypeConverter(List<ConversionService> conversionServices) {
        this.conversionServices = conversionServices;
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
        for (ConversionService conversionService : this.conversionServices) {
            if (!conversionService.canConvert(value.getClass(), type)) continue;
            return (T)conversionService.convert(value, type);
        }
        return null;
    }
}

