/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class GroupCondition
extends SpringBootCondition {
    private final String group;
    private final String single;
    private final boolean groupDefault;
    private final boolean singleDefault;

    public GroupCondition(String group, String single) {
        this(group, true, single, true);
    }

    public GroupCondition(String group, boolean groupDefault, String single, boolean singleDefault) {
        this.group = group.endsWith(".") ? group : group + ".";
        this.groupDefault = groupDefault;
        this.single = group.endsWith(".") ? single : single + ".";
        this.singleDefault = singleDefault;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        boolean groupEnabled = GroupCondition.isEnabled(conditionContext, this.group, true);
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)this.single, (Object[])new Object[0]);
        if (GroupCondition.isEnabled(conditionContext, this.single, groupEnabled)) {
            return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
    }

    public static boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
        return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
    }
}

