/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckFilter;
import org.apache.camel.health.HealthCheckHelper;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class CamelHealthCheckIndicator
extends AbstractHealthIndicator {
    private final CamelContext camelContext;
    private final List<HealthCheckFilter> filters;

    public CamelHealthCheckIndicator(CamelContext camelContext, List<HealthCheckFilter> filters) {
        this.camelContext = camelContext;
        this.filters = filters;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.unknown();
        if (this.camelContext != null) {
            Collection results = HealthCheckHelper.invoke((CamelContext)this.camelContext, check -> this.filters.stream().anyMatch(p -> p.test(check)));
            if (!results.isEmpty()) {
                builder.up();
            }
            for (HealthCheck.Result result : results) {
                builder.withDetail(result.getCheck().getId(), (Object)result.getState().name());
                if (result.getState() != HealthCheck.State.DOWN) continue;
                builder.down();
            }
        }
    }
}

