/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.component.spring.integration;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.spring.integration.adapter.CamelTargetAdapter;
import org.apache.camel.impl.DefaultExchange;

/**
 * An {@link Exchange} for working with Spring Integration endpoints which exposes the underlying
 * Spring messages via {@link #getIn()} and {@link #getOut()}
 *
 * @version $Revision: 774164 $
 */
public class SpringIntegrationExchange extends DefaultExchange {

    public SpringIntegrationExchange(SpringIntegrationEndpoint endpoint) {
        super(endpoint);
    }

    public SpringIntegrationExchange(SpringIntegrationEndpoint endpoint, ExchangePattern pattern) {
        super(endpoint, pattern);
    }

    public SpringIntegrationExchange(CamelTargetAdapter adapter, ExchangePattern pattern) {
        super(adapter.getCamelContext(), pattern);
    }

    public SpringIntegrationEndpoint getFromSpringIntegrationEndpoint() {
        return (SpringIntegrationEndpoint) super.getFromEndpoint();

    }

    @Override
    public Exchange newInstance() {
        if (getFromSpringIntegrationEndpoint() != null) {
            return new SpringIntegrationExchange(getFromSpringIntegrationEndpoint());
        } else {
            return new DefaultExchange(this.getContext(), this.getPattern());
        }
    }

    @Override
    protected Message createFaultMessage() {
        return new SpringIntegrationMessage();
    }

    @Override
    protected Message createInMessage() {
        return new SpringIntegrationMessage();
    }

    @Override
    protected Message createOutMessage() {
        return new SpringIntegrationMessage();
    }

}
