/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.component.spring.integration.SpringIntegrationMessage;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.BeanFactoryChannelResolver;
import org.springframework.integration.channel.ChannelResolver;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.message.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringIntegrationConsumer
extends DefaultConsumer
implements MessageHandler {
    private SpringCamelContext context;
    private DirectChannel inputChannel;
    private MessageChannel outputChannel;
    private String inputChannelName;
    private ChannelResolver channelResolver;
    private SpringIntegrationEndpoint endpoint;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpringIntegrationConsumer(SpringIntegrationEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.context = (SpringCamelContext)endpoint.getCamelContext();
        if (this.context != null && endpoint.getMessageChannel() == null) {
            this.channelResolver = new BeanFactoryChannelResolver((BeanFactory)this.context.getApplicationContext());
            this.inputChannelName = endpoint.getDefaultChannel();
            if (ObjectHelper.isEmpty((Object)this.inputChannelName)) {
                this.inputChannelName = endpoint.getInputChannel();
            }
            if (ObjectHelper.isEmpty((Object)this.inputChannelName)) throw new RuntimeCamelException("Can't find the right inputChannelName, please check your configuration.");
            this.inputChannel = (DirectChannel)this.channelResolver.resolveChannelName(this.inputChannelName);
            ObjectHelper.notNull((Object)this.inputChannel, (String)("The inputChannel with the name [" + this.inputChannelName + "]"));
        } else {
            if (endpoint.getMessageChannel() == null) throw new RuntimeCamelException("Can't find the right message channel, please check your configuration.");
            this.inputChannel = (DirectChannel)endpoint.getMessageChannel();
        }
        if (!endpoint.isInOut()) return;
        endpoint.setExchangePattern(ExchangePattern.InOut);
    }

    protected void doStop() throws Exception {
        this.inputChannel.unsubscribe((MessageHandler)this);
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.inputChannel.subscribe((MessageHandler)this);
    }

    public void handleMessage(org.springframework.integration.core.Message<?> siInMessage) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setIn((Message)new SpringIntegrationMessage(siInMessage));
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.endpoint.isInOut()) {
            Object returnAddress = siInMessage.getHeaders().getReplyChannel();
            MessageChannel reply = null;
            if (returnAddress != null) {
                if (returnAddress instanceof String) {
                    reply = (MessageChannel)this.context.getApplicationContext().getBean((String)returnAddress);
                } else if (returnAddress instanceof MessageChannel) {
                    reply = (MessageChannel)returnAddress;
                }
            } else if (this.outputChannel != null) {
                reply = this.outputChannel;
            } else if (ObjectHelper.isEmpty((Object)this.endpoint.getOutputChannel())) {
                this.outputChannel = this.channelResolver.resolveChannelName(this.endpoint.getOutputChannel());
                ObjectHelper.notNull((Object)this.inputChannel, (String)("The outputChannel with the name [" + this.endpoint.getOutputChannel() + "]"));
                reply = this.outputChannel;
            } else {
                throw new RuntimeCamelException("Can't find the right outputChannelName");
            }
            org.springframework.integration.core.Message siOutMessage = SpringIntegrationBinding.storeToSpringIntegrationMessage(exchange.getOut());
            reply.send(siOutMessage);
        }
    }
}

