/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.spring.integration.converter.SpringIntegrationConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.springframework.messaging.MessageChannel;

@DeferredContextBinding
public final class SpringIntegrationConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SpringIntegrationConverterLoader.addTypeConverter(registry, Endpoint.class, MessageChannel.class, false, (type, exchange, value) -> SpringIntegrationConverter.toEndpoint((MessageChannel)value));
        SpringIntegrationConverterLoader.addTypeConverter(registry, Message.class, org.springframework.messaging.Message.class, false, (type, exchange, value) -> SpringIntegrationConverter.toCamelMessage((org.springframework.messaging.Message)value));
        SpringIntegrationConverterLoader.addTypeConverter(registry, org.springframework.messaging.Message.class, Message.class, false, (type, exchange, value) -> SpringIntegrationConverter.toSpringMessage((Message)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

