/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.javaconfig;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.camel.main.MainSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class Main
extends org.apache.camel.spring.Main {
    private String basedPackages;
    private String configClassesString;

    public Main() {
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("bp", "basedPackages", "Sets the based packages of spring java config ApplicationContext", "basedPackages"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setBasedPackages(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainSupport.ParameterOption("cc", "configClasses", "Sets the config Class of spring java config ApplicationContext", "configureClasses"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setConfigClassesString(parameter);
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        instance = main;
        main.enableHangupSupport();
        main.run(args);
    }

    public void setBasedPackages(String config) {
        this.basedPackages = config;
    }

    public String getBasedPackages() {
        return this.basedPackages;
    }

    public void setConfigClassesString(String config) {
        this.configClassesString = config;
    }

    public String getConfigClassesString() {
        return this.configClassesString;
    }

    private Class<?>[] getConfigClasses(String configureClasses) {
        String[] classes;
        ArrayList<Class> answer = new ArrayList<Class>();
        for (String className : classes = configureClasses.split(";")) {
            Class configClass = ObjectHelper.loadClass((String)className);
            if (configClass == null) continue;
            answer.add(configClass);
        }
        return answer.toArray(new Class[answer.size()]);
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        AnnotationConfigApplicationContext acApplicationContext = new AnnotationConfigApplicationContext();
        if (parentContext != null) {
            acApplicationContext.setParent((ApplicationContext)parentContext);
        }
        if (this.getConfigClassesString() != null) {
            Class<?>[] configClasses = this.getConfigClasses(this.getConfigClassesString());
            for (Class<?> cls : configClasses) {
                acApplicationContext.register(new Class[]{cls});
            }
        }
        if (this.getBasedPackages() != null) {
            String[] basePackages = this.getBasedPackages().split(";");
            for (String basePackage : basePackages) {
                acApplicationContext.scan(new String[]{basePackage});
            }
        }
        acApplicationContext.refresh();
        return acApplicationContext;
    }
}

