/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springldap;

import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.springldap.LdapOperation;
import org.apache.camel.component.springldap.SpringLdapEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;

public class SpringLdapProducer
extends DefaultProducer {
    public static final String DN = "dn";
    public static final String FILTER = "filter";
    public static final String ATTRIBUTES = "attributes";
    SpringLdapEndpoint endpoint;
    private AttributesMapper mapper = new AttributesMapper(){

        public Object mapFromAttributes(Attributes attributes) throws NamingException {
            return attributes;
        }
    };

    public SpringLdapProducer(SpringLdapEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Map body = (Map)exchange.getIn().getBody(Map.class);
        String dn = (String)body.get(DN);
        if (null == dn || dn.length() == 0) {
            throw new UnsupportedOperationException("DN must not be empty, but you provided an empty DN");
        }
        LdapOperation operation = this.endpoint.getOperation();
        LdapTemplate ldapTemplate = this.endpoint.getLdapTemplate();
        if (null == operation) {
            throw new UnsupportedOperationException("LDAP operation must not be empty, but you provided an empty operation");
        }
        switch (operation) {
            case SEARCH: {
                String filter = (String)body.get(FILTER);
                exchange.getIn().setBody((Object)ldapTemplate.search(dn, filter, this.endpoint.getScope(), this.mapper));
                break;
            }
            case BIND: {
                Attributes attributes = (Attributes)body.get(ATTRIBUTES);
                ldapTemplate.bind(dn, null, attributes);
                break;
            }
            case UNBIND: {
                ldapTemplate.unbind(dn);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Bug in the Spring-LDAP component. Despite of all assertions, you managed to call an unsupported operation '" + (Object)((Object)operation) + "'");
            }
        }
    }
}

