/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springldap;

import java.util.Map;
import java.util.function.BiFunction;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.springldap.LdapOperation;
import org.apache.camel.component.springldap.SpringLdapEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.query.LdapQueryBuilder;

public class SpringLdapProducer
extends DefaultProducer {
    public static final String DN = "dn";
    public static final String FILTER = "filter";
    public static final String ATTRIBUTES = "attributes";
    public static final String PASSWORD = "password";
    public static final String MODIFICATION_ITEMS = "modificationItems";
    public static final String FUNCTION = "function";
    public static final String REQUEST = "request";
    SpringLdapEndpoint endpoint;
    private AttributesMapper<Object> mapper = new AttributesMapper<Object>(){

        public Object mapFromAttributes(Attributes attributes) throws NamingException {
            return attributes;
        }
    };

    public SpringLdapProducer(SpringLdapEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        ContextSource contextSource;
        Map body = (Map)exchange.getIn().getBody(Map.class);
        LdapOperation operation = this.endpoint.getOperation();
        if (null == operation) {
            throw new UnsupportedOperationException("LDAP operation must not be empty, but you provided an empty operation");
        }
        LdapTemplate ldapTemplate = this.endpoint.getLdapTemplate();
        String dn = (String)body.get(DN);
        if (StringUtils.isBlank((String)dn) && (contextSource = ldapTemplate.getContextSource()) instanceof BaseLdapPathContextSource) {
            dn = ((BaseLdapPathContextSource)contextSource).getBaseLdapPathAsString();
        }
        if (operation != LdapOperation.FUNCTION_DRIVEN && StringUtils.isBlank((String)dn)) {
            throw new UnsupportedOperationException("DN must not be empty, but you provided an empty DN");
        }
        switch (operation) {
            case SEARCH: {
                String filter = (String)body.get(FILTER);
                exchange.getIn().setBody((Object)ldapTemplate.search(dn, filter, this.endpoint.scopeValue(), this.mapper));
                break;
            }
            case BIND: {
                Attributes attributes = (Attributes)body.get(ATTRIBUTES);
                ldapTemplate.bind(dn, null, attributes);
                break;
            }
            case UNBIND: {
                ldapTemplate.unbind(dn);
                break;
            }
            case AUTHENTICATE: {
                ldapTemplate.authenticate(LdapQueryBuilder.query().base(dn).filter((String)body.get(FILTER)), (String)body.get(PASSWORD));
                break;
            }
            case MODIFY_ATTRIBUTES: {
                ModificationItem[] modificationItems = (ModificationItem[])body.get(MODIFICATION_ITEMS);
                ldapTemplate.modifyAttributes(dn, modificationItems);
                break;
            }
            case FUNCTION_DRIVEN: {
                BiFunction ldapOperationFunction = (BiFunction)body.get(FUNCTION);
                Object ldapOperationRequest = body.get(REQUEST);
                exchange.getIn().setBody(ldapOperationFunction.apply(ldapTemplate, ldapOperationRequest));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Bug in the Spring-LDAP component. Despite of all assertions, you managed to call an unsupported operation '" + operation + "'");
            }
        }
    }
}

