/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.util.Map;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.springrabbit.EndpointMessageListener;
import org.apache.camel.component.springrabbit.MessageListenerContainer;
import org.apache.camel.component.springrabbit.MessagePropertiesConverter;
import org.apache.camel.component.springrabbit.SpringRabbitMQComponent;
import org.apache.camel.component.springrabbit.SpringRabbitMQConstants;
import org.apache.camel.component.springrabbit.SpringRabbitMQConsumer;
import org.apache.camel.component.springrabbit.SpringRabbitMQHelper;
import org.apache.camel.component.springrabbit.SpringRabbitMQProducer;
import org.apache.camel.component.springrabbit.SpringRabbitPollingConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;

@UriEndpoint(firstVersion="3.8.0", scheme="spring-rabbitmq", title="Spring RabbitMQ", syntax="spring-rabbitmq:exchangeName", category={Category.MESSAGING}, headersClass=SpringRabbitMQConstants.class)
public class SpringRabbitMQEndpoint
extends DefaultEndpoint
implements AsyncEndpoint {
    public static final String ARG_PREFIX = "arg.";
    public static final String CONSUMER_ARG_PREFIX = "consumer.";
    public static final String EXCHANGE_ARG_PREFIX = "exchange.";
    public static final String QUEUE_ARG_PREFIX = "queue.";
    public static final String BINDING_ARG_PREFIX = "binding.";
    public static final String DLQ_EXCHANGE_ARG_PREFIX = "dlq.exchange.";
    public static final String DLQ_QUEUE_ARG_PREFIX = "dlq.queue.";
    public static final String DLQ_BINDING_PREFIX = "dlq.binding.";
    private static final Logger LOG = LoggerFactory.getLogger(SpringRabbitMQEndpoint.class);
    @UriPath
    @Metadata(required=true, description="The exchange name determines the exchange to which the produced messages will be sent to. In the case of consumers, the exchange name determines the exchange the queue will be bound to. Note: to use default exchange then do not use empty name, but use default instead.")
    private String exchangeName;
    @UriParam(label="consumer", defaultValue="direct", enums="direct,fanout,headers,topic", description="The type of the exchange")
    private String exchangeType = "direct";
    @UriParam(label="common", description="The value of a routing key to use. Default is empty which is not helpful when using the default (or any direct) exchange, but fine if the exchange is a headers exchange for instance.")
    private String routingKey = "";
    @UriParam(label="common", description="The connection factory to be use. A connection factory must be configured either on the component or endpoint.")
    private ConnectionFactory connectionFactory;
    @UriParam(label="consumer", description="The queue(s) to use for consuming messages. Multiple queue names can be separated by comma. If none has been configured then Camel will generate an unique id as the queue name for the consumer.")
    private String queues;
    @UriParam(label="consumer", defaultValue="true", description="Specifies whether the consumer container should auto-startup.")
    private boolean autoStartup = true;
    @UriParam(label="consumer", defaultValue="true", description="Specifies whether the consumer should auto declare binding between exchange, queue and routing key when starting.")
    private boolean autoDeclare = true;
    @UriParam(label="consumer", description="Whether the consumer processes the Exchange asynchronously. If enabled then the consumer may pickup the next message from the queue, while the previous message is being processed asynchronously (by the Asynchronous Routing Engine). This means that messages may be processed not 100% strictly in order. If disabled (as default) then the Exchange is fully processed before the consumer will pickup the next message from the queue.")
    private boolean asyncConsumer;
    @UriParam(description="Specifies whether to test the connection on startup. This ensures that when Camel starts that all the JMS consumers have a valid connection to the JMS broker. If a connection cannot be granted then Camel throws an exception on startup. This ensures that Camel is not started with failed connections. The JMS producers is tested as well.")
    private boolean testConnectionOnStartup;
    @UriParam(label="advanced", description="To use a custom MessageConverter so you can be in control how to map to/from a org.springframework.amqp.core.Message.")
    private MessageConverter messageConverter;
    @UriParam(label="advanced", description="To use a custom MessagePropertiesConverter so you can be in control how to map to/from a org.springframework.amqp.core.MessageProperties.")
    private MessagePropertiesConverter messagePropertiesConverter;
    @UriParam(label="advanced", prefix="arg.", multiValue=true, description="Specify arguments for configuring the different RabbitMQ concepts, a different prefix is required for each element: arg.consumer. arg.exchange. arg.queue. arg.binding. arg.dlq.exchange. arg.dlq.queue. arg.dlq.binding. For example to declare a queue with message ttl argument: args=arg.queue.x-message-ttl=60000")
    private Map<String, Object> args;
    @UriParam(label="consumer", description="Flag controlling the behaviour of the container with respect to message acknowledgement. The most common usage is to let the container handle the acknowledgements (so the listener doesn't need to know about the channel or the message). Set to AcknowledgeMode.MANUAL if the listener will send the acknowledgements itself using Channel.basicAck(long, boolean). Manual acks are consistent with either a transactional or non-transactional channel, but if you are doing no other work on the channel at the same other than receiving a single message then the transaction is probably unnecessary. Set to AcknowledgeMode.NONE to tell the broker not to expect any acknowledgements, and it will assume all messages are acknowledged as soon as they are sent (this is autoack in native Rabbit broker terms). If AcknowledgeMode.NONE then the channel cannot be transactional (so the container will fail on start up if that flag is accidentally set).")
    private AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    @UriParam(label="consumer", description="Set to true for an exclusive consumer")
    private boolean exclusive;
    @UriParam(label="consumer", description="Set to true for an no-local consumer")
    private boolean noLocal;
    @UriParam(label="consumer", description="The name of the dead letter exchange")
    private String deadLetterExchange;
    @UriParam(label="consumer", description="The name of the dead letter queue")
    private String deadLetterQueue;
    @UriParam(label="consumer", description="The routing key for the dead letter exchange")
    private String deadLetterRoutingKey;
    @UriParam(label="consumer", defaultValue="direct", enums="direct,fanout,headers,topic", description="The type of the dead letter exchange")
    private String deadLetterExchangeType = "direct";
    @UriParam(label="common", description="Specifies whether Camel ignores the ReplyTo header in messages. If true, Camel does not send a reply back to the destination specified in the ReplyTo header. You can use this option if you want Camel to consume from a route and you do not want Camel to automatically send back a reply message because another component in your code handles the reply message. You can also use this option if you want to use Camel as a proxy between different message brokers and you want to route message from one system to another.")
    private boolean disableReplyTo;
    @UriParam(label="producer", javaType="java.time.Duration", defaultValue="30000", description="Specify the timeout in milliseconds to be used when waiting for a reply message when doing request/reply (InOut) messaging. The default value is 30 seconds. A negative value indicates an indefinite timeout (Beware that this will cause a memory leak if a reply is not received).")
    private long replyTimeout = 30000L;
    @UriParam(label="producer", javaType="java.time.Duration", defaultValue="5000", description="Specify the timeout in milliseconds to be used when waiting for a message sent to be confirmed by RabbitMQ when doing send only messaging (InOnly). The default value is 5 seconds. A negative value indicates an indefinite timeout.")
    private long confirmTimeout = 5000L;
    @UriParam(label="producer", enums="auto,enabled,disabled", defaultValue="auto", description="Controls whether to wait for confirms. The connection factory must be configured for publisher confirms and this method. auto = Camel detects if the connection factory uses confirms or not. disabled = Confirms is disabled. enabled = Confirms is enabled.")
    private String confirm = "auto";
    @UriParam(label="producer", defaultValue="false", description="Use a separate connection for publishers and consumers")
    private boolean usePublisherConnection;
    @UriParam(defaultValue="false", label="advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;
    @UriParam(label="consumer,advanced", description="Tell the broker how many messages to send in a single request. Often this can be set quite high to improve throughput.")
    private Integer prefetchCount;
    @UriParam(label="consumer,advanced", defaultValue="DMLC", enums="DMLC,SMLC", description="The type of the MessageListenerContainer")
    private String messageListenerContainerType = "DMLC";
    @UriParam(label="consumer,advanced", description="The number of consumers")
    private Integer concurrentConsumers;
    @UriParam(label="consumer,advanced", description="The maximum number of consumers (available only with SMLC)")
    private Integer maxConcurrentConsumers;
    @UriParam(label="consumer,advanced", description="Custom retry configuration to use. If this is configured then the other settings such as maximumRetryAttempts for retry are not in use.")
    private RetryOperationsInterceptor retry;
    @UriParam(label="consumer", defaultValue="5", description="How many times a Rabbitmq consumer will retry the same message if Camel failed to process the message")
    private int maximumRetryAttempts = 5;
    @UriParam(label="consumer", defaultValue="1000", description="Delay in millis a Rabbitmq consumer will wait before redelivering a message that Camel failed to process")
    private int retryDelay = 1000;
    @UriParam(label="consumer", defaultValue="true", description="Whether a Rabbitmq consumer should reject the message without requeuing. This enables failed messages to be sent to a Dead Letter Exchange/Queue, if the broker is so configured.")
    private boolean rejectAndDontRequeue = true;

    public SpringRabbitMQEndpoint(String endpointUri, Component component, String exchangeName) {
        super(endpointUri, component);
        this.exchangeName = exchangeName;
    }

    public SpringRabbitMQComponent getComponent() {
        return (SpringRabbitMQComponent)super.getComponent();
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getQueues() {
        return this.queues;
    }

    public void setQueues(String queues) {
        this.queues = queues;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoDeclare() {
        return this.autoDeclare;
    }

    public void setAutoDeclare(boolean autoDeclare) {
        this.autoDeclare = autoDeclare;
    }

    public boolean isAsyncConsumer() {
        return this.asyncConsumer;
    }

    public void setAsyncConsumer(boolean asyncConsumer) {
        this.asyncConsumer = asyncConsumer;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public boolean isTestConnectionOnStartup() {
        return this.testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public MessagePropertiesConverter getMessagePropertiesConverter() {
        return this.messagePropertiesConverter;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(String deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public String getDeadLetterRoutingKey() {
        return this.deadLetterRoutingKey;
    }

    public void setDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.deadLetterRoutingKey = deadLetterRoutingKey;
    }

    public String getDeadLetterExchangeType() {
        return this.deadLetterExchangeType;
    }

    public void setDeadLetterExchangeType(String deadLetterExchangeType) {
        this.deadLetterExchangeType = deadLetterExchangeType;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public long getConfirmTimeout() {
        return this.confirmTimeout;
    }

    public void setConfirmTimeout(long confirmTimeout) {
        this.confirmTimeout = confirmTimeout;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isUsePublisherConnection() {
        return this.usePublisherConnection;
    }

    public void setUsePublisherConnection(boolean usePublisherConnection) {
        this.usePublisherConnection = usePublisherConnection;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public Integer getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(Integer prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public String getMessageListenerContainerType() {
        return this.messageListenerContainerType;
    }

    public void setMessageListenerContainerType(String messageListenerContainerType) {
        this.messageListenerContainerType = messageListenerContainerType;
    }

    public Integer getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(Integer concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public Integer getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public RetryOperationsInterceptor getRetry() {
        return this.retry;
    }

    public void setRetry(RetryOperationsInterceptor retry) {
        this.retry = retry;
    }

    public int getMaximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public void setMaximumRetryAttempts(int maximumRetryAttempts) {
        this.maximumRetryAttempts = maximumRetryAttempts;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public boolean isRejectAndDontRequeue() {
        return this.rejectAndDontRequeue;
    }

    public void setRejectAndDontRequeue(boolean rejectAndDontRequeue) {
        this.rejectAndDontRequeue = rejectAndDontRequeue;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.createMessageListenerContainer();
        SpringRabbitMQConsumer consumer = new SpringRabbitMQConsumer((Endpoint)this, processor, listenerContainer);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        SpringRabbitPollingConsumer answer = new SpringRabbitPollingConsumer(this, this.createInOnlyTemplate());
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new SpringRabbitMQProducer((Endpoint)this);
    }

    public Exchange createExchange(Message message) {
        Object body = this.getMessageConverter().fromMessage(message);
        Exchange exchange = super.createExchange();
        exchange.getMessage().setBody(body);
        Map<String, Object> headers = this.getMessagePropertiesConverter().fromMessageProperties(message.getMessageProperties(), exchange);
        if (!headers.isEmpty()) {
            exchange.getMessage().setHeaders(headers);
        }
        return exchange;
    }

    public Map<String, Object> getConsumerArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)CONSUMER_ARG_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public Map<String, Object> getExchangeArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)EXCHANGE_ARG_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public Map<String, Object> getQueueArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)QUEUE_ARG_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public Map<String, Object> getBindingArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)BINDING_ARG_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public Map<String, Object> getDlqExchangeArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)DLQ_EXCHANGE_ARG_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public Map<String, Object> getDlqQueueArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)DLQ_QUEUE_ARG_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public Map<String, Object> getDlqBindingArgs() {
        Map answer = PropertiesHelper.extractProperties(this.args, (String)DLQ_BINDING_PREFIX, (boolean)false);
        this.prepareArgs(answer);
        return answer;
    }

    public RabbitTemplate createInOnlyTemplate() {
        RabbitTemplate template = new RabbitTemplate(this.getConnectionFactory());
        template.setRoutingKey(this.getRoutingKey());
        template.setUsePublisherConnection(this.usePublisherConnection);
        return template;
    }

    public AsyncRabbitTemplate createInOutTemplate() {
        RabbitTemplate template = new RabbitTemplate(this.getConnectionFactory());
        template.setRoutingKey(this.routingKey);
        template.setUsePublisherConnection(this.usePublisherConnection);
        AsyncRabbitTemplate asyncTemplate = new AsyncRabbitTemplate(template);
        asyncTemplate.setReceiveTimeout(this.replyTimeout);
        return asyncTemplate;
    }

    public AbstractMessageListenerContainer createMessageListenerContainer() {
        return this.getComponent().getListenerContainerFactory().createListenerContainer(this);
    }

    public void configureMessageListener(EndpointMessageListener listener) {
        listener.setAsync(this.isAsyncConsumer());
        listener.setDisableReplyTo(this.isDisableReplyTo());
    }

    protected boolean parseArgsBoolean(Map<String, Object> args, String key, String defaultValue) {
        Object answer = args.remove(key);
        if (answer == null) {
            answer = defaultValue;
        }
        if (answer != null) {
            return (Boolean)this.getCamelContext().getTypeConverter().convertTo(Boolean.TYPE, answer);
        }
        return false;
    }

    protected String parseArgsString(Map<String, Object> args, String key, String defaultValue) {
        Object answer = args.remove(key);
        if (answer == null) {
            answer = defaultValue;
        }
        if (answer != null) {
            return (String)this.getCamelContext().getTypeConverter().convertTo(String.class, answer);
        }
        return null;
    }

    public void declareElements(AbstractMessageListenerContainer container) {
        AmqpAdmin admin = null;
        if (container instanceof MessageListenerContainer) {
            admin = ((MessageListenerContainer)container).getAmqpAdmin();
        }
        if (admin != null && this.autoDeclare) {
            if (this.deadLetterExchange != null) {
                ExchangeBuilder eb = new ExchangeBuilder(this.deadLetterExchange, this.deadLetterExchangeType);
                eb.withArguments(this.getDlqExchangeArgs());
                org.springframework.amqp.core.Exchange rabbitExchange = eb.build();
                admin.declareExchange(rabbitExchange);
                if (this.deadLetterQueue != null) {
                    QueueBuilder qb = QueueBuilder.durable((String)this.deadLetterQueue);
                    Map<String, Object> args = this.getDlqQueueArgs();
                    qb.withArguments(args);
                    Queue rabbitQueue = qb.build();
                    admin.declareQueue(rabbitQueue);
                    Binding binding = new Binding(rabbitQueue.getName(), Binding.DestinationType.QUEUE, rabbitExchange.getName(), this.deadLetterRoutingKey, this.getDlqBindingArgs());
                    admin.declareBinding(binding);
                    LOG.info("Auto-declaring durable DeadLetterExchange: {} routingKey: {}", (Object)this.deadLetterExchange, (Object)this.deadLetterRoutingKey);
                }
            }
            Map<String, Object> map = this.getExchangeArgs();
            boolean durable = this.parseArgsBoolean(map, "durable", "true");
            boolean autoDelete = this.parseArgsBoolean(map, "autoDelete", "false");
            if (!durable || autoDelete) {
                LOG.info("Auto-declaring a non-durable or auto-delete Exchange ({}) durable:{}, auto-delete:{}. It will be deleted by the broker if it shuts down, and can be redeclared by closing and reopening the connection.", new Object[]{this.exchangeName, durable, autoDelete});
            }
            String en = SpringRabbitMQHelper.isDefaultExchange(this.getExchangeName()) ? "" : this.getExchangeName();
            ExchangeBuilder eb = new ExchangeBuilder(en, this.getExchangeType());
            eb.durable(durable);
            if (autoDelete) {
                eb.autoDelete();
            }
            eb.withArguments(map);
            org.springframework.amqp.core.Exchange rabbitExchange = eb.build();
            admin.declareExchange(rabbitExchange);
            String queuesToDeclare = this.queues;
            String autoDeleteDefault = "false";
            boolean generateUniqueQueue = false;
            if (queuesToDeclare == null) {
                queuesToDeclare = " ";
                generateUniqueQueue = true;
            }
            for (String queue : queuesToDeclare.split(",")) {
                String dlrk;
                String dle;
                QueueBuilder qb;
                queue = queue.trim();
                map = this.getQueueArgs();
                this.prepareDeadLetterQueueArgs(map);
                durable = this.parseArgsBoolean(map, "durable", "false");
                autoDelete = this.parseArgsBoolean(map, "autoDelete", autoDeleteDefault);
                boolean exclusive = this.parseArgsBoolean(map, "exclusive", "false");
                if (queue.isEmpty()) {
                    qb = durable ? QueueBuilder.durable() : QueueBuilder.nonDurable();
                } else {
                    QueueBuilder queueBuilder = qb = durable ? QueueBuilder.durable((String)queue) : QueueBuilder.nonDurable((String)queue);
                }
                if (autoDelete) {
                    qb.autoDelete();
                }
                if (exclusive) {
                    qb.exclusive();
                }
                if ((dle = this.parseArgsString(this.args, "x-dead-letter-exchange", this.deadLetterExchange)) != null) {
                    qb.deadLetterExchange(dle);
                }
                if ((dlrk = this.parseArgsString(this.args, "x-dead-letter-routing-key", this.deadLetterRoutingKey)) != null) {
                    qb.deadLetterRoutingKey(dlrk);
                }
                qb.withArguments(map);
                Queue rabbitQueue = qb.build();
                if (!durable || autoDelete || exclusive) {
                    LOG.info("Auto-declaring a non-durable, auto-delete, or exclusive Queue ({})durable:{}, auto-delete:{}, exclusive:{}. It will be redeclared if the broker stops and is restarted while the connection factory is alive, but all messages will be lost.", new Object[]{rabbitQueue.getName(), durable, autoDelete, exclusive});
                }
                String qn = admin.declareQueue(rabbitQueue);
                if (generateUniqueQueue) {
                    container.setQueueNames(new String[]{qn});
                }
                Binding binding = new Binding(qn, Binding.DestinationType.QUEUE, rabbitExchange.getName(), this.routingKey, this.getBindingArgs());
                admin.declareBinding(binding);
            }
        }
    }

    private void prepareDeadLetterQueueArgs(Map<String, Object> args) {
        if (this.deadLetterExchange != null) {
            args.put("x-dead-letter-exchange", this.deadLetterExchange);
            if (this.deadLetterRoutingKey != null) {
                args.put("x-dead-letter-routing-key", this.deadLetterRoutingKey);
            }
        }
    }

    private void prepareArgs(Map<String, Object> args) {
        Object arg = args.get("x-max-length");
        if (arg instanceof String) {
            args.put("x-max-length", Long.parseLong((String)arg));
        }
        if ((arg = args.get("x-max-length-bytes")) instanceof String) {
            args.put("x-max-length-bytes", Long.parseLong((String)arg));
        }
        if ((arg = args.get("x-max-priority")) instanceof String) {
            args.put("x-max-priority", Integer.parseInt((String)arg));
        }
        if ((arg = args.get("x-delivery-limit")) instanceof String) {
            args.put("x-delivery-limit", Integer.parseInt((String)arg));
        }
        if ((arg = args.get("x-message-ttl")) instanceof String) {
            args.put("x-message-ttl", Long.parseLong((String)arg));
        }
        if ((arg = args.get("x-expires")) instanceof String) {
            args.put("x-expires", Long.parseLong((String)arg));
        }
        if ((arg = args.get("x-single-active-consumer")) instanceof String) {
            args.put("x-single-active-consumer", Boolean.parseBoolean((String)arg));
        }
    }
}

