/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import org.aopalliance.aop.Advice;
import org.apache.camel.component.springrabbit.CamelDirectMessageListenerContainer;
import org.apache.camel.component.springrabbit.CamelSimpleMessageListenerContainer;
import org.apache.camel.component.springrabbit.ListenerContainerFactory;
import org.apache.camel.component.springrabbit.MessageListenerContainer;
import org.apache.camel.component.springrabbit.SpringRabbitMQEndpoint;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;

public class DefaultListenerContainerFactory
implements ListenerContainerFactory {
    @Override
    public AbstractMessageListenerContainer createListenerContainer(SpringRabbitMQEndpoint endpoint) {
        MessageListenerContainer listener = endpoint.getMessageListenerContainerType().equalsIgnoreCase("SMLC") ? new CamelSimpleMessageListenerContainer(endpoint) : new CamelDirectMessageListenerContainer(endpoint);
        if (endpoint.getQueues() != null) {
            listener.setQueueNames(endpoint.getQueues().split(","));
        }
        listener.setAcknowledgeMode(endpoint.getAcknowledgeMode());
        listener.setExclusive(endpoint.isExclusive());
        listener.setNoLocal(endpoint.isNoLocal());
        AmqpAdmin admin = endpoint.getComponent().getAmqpAdmin();
        if (endpoint.isAutoDeclare() && admin == null) {
            RabbitAdmin ra = new RabbitAdmin(endpoint.getConnectionFactory());
            ra.setIgnoreDeclarationExceptions(endpoint.getComponent().isIgnoreDeclarationExceptions());
            admin = ra;
        }
        listener.setAutoDeclare(endpoint.isAutoDeclare());
        listener.setAmqpAdmin(admin);
        if (endpoint.getComponent().getErrorHandler() != null) {
            listener.setErrorHandler(endpoint.getComponent().getErrorHandler());
        }
        listener.setPrefetchCount(endpoint.getPrefetchCount());
        listener.setShutdownTimeout(endpoint.getComponent().getShutdownTimeout());
        listener.setConsumerArguments(endpoint.getConsumerArgs());
        if (endpoint.getRetry() != null) {
            listener.setAdviceChain(new Advice[]{endpoint.getRetry()});
        } else {
            RetryInterceptorBuilder.StatelessRetryInterceptorBuilder builder = RetryInterceptorBuilder.stateless();
            if (endpoint.getMaximumRetryAttempts() > 0) {
                builder.retryPolicy((RetryPolicy)new SimpleRetryPolicy(endpoint.getMaximumRetryAttempts()));
            }
            if (endpoint.getRetryDelay() > 0) {
                FixedBackOffPolicy delay = new FixedBackOffPolicy();
                delay.setBackOffPeriod((long)endpoint.getRetryDelay());
                builder.backOffPolicy((BackOffPolicy)delay);
            }
            if (endpoint.isRejectAndDontRequeue()) {
                builder.recoverer((MessageRecoverer)new RejectAndDontRequeueRecoverer());
            }
            listener.setAdviceChain(new Advice[]{builder.build()});
        }
        return listener;
    }
}

