/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis.processor.idempotent;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;

@Metadata(label="bean", description="Idempotent repository that uses Redis to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="Spring Redis based message id repository")
public class SpringRedisIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private SetOperations<String, String> setOperations;
    @Metadata(description="Name of repository", required=true)
    private String repositoryName;
    @Metadata(description="Redis configuration")
    private RedisConfiguration redisConfiguration;
    private RedisTemplate<String, String> redisTemplate;
    @Metadata(label="advanced", description="Delete all keys of the currently selected database. Be careful if enabling this as all existing data will be deleted.")
    private boolean flushOnStartup;

    public SpringRedisIdempotentRepository() {
    }

    public SpringRedisIdempotentRepository(RedisTemplate<String, String> redisTemplate, String repositoryName) {
        this.setOperations = redisTemplate.opsForSet();
        this.repositoryName = repositoryName;
        this.redisTemplate = redisTemplate;
    }

    public SpringRedisIdempotentRepository(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public static SpringRedisIdempotentRepository redisIdempotentRepository(String processorName) {
        return new SpringRedisIdempotentRepository(processorName);
    }

    public static SpringRedisIdempotentRepository redisIdempotentRepository(RedisTemplate<String, String> redisTemplate, String processorName) {
        return new SpringRedisIdempotentRepository(redisTemplate, processorName);
    }

    public boolean isFlushOnStartup() {
        return this.flushOnStartup;
    }

    public void setFlushOnStartup(boolean flushOnStartup) {
        this.flushOnStartup = flushOnStartup;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        if (!this.contains(key)) {
            return this.setOperations.add((Object)this.repositoryName, (Object[])new String[]{key}) != null;
        }
        return false;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.setOperations.isMember((Object)this.repositoryName, (Object)key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        return this.setOperations.remove((Object)this.repositoryName, new Object[]{key}) != null;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.redisTemplate.getConnectionFactory().getConnection().flushDb();
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @ManagedAttribute(description="The repository name")
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean confirm(String key) {
        return true;
    }

    protected void doStart() throws Exception {
        if (this.redisConfiguration == null && this.redisTemplate == null) {
            this.redisConfiguration = new RedisConfiguration();
        }
        if (this.redisTemplate == null) {
            this.redisTemplate = this.redisConfiguration.getRedisTemplate();
        }
        ObjectHelper.notNull(this.redisTemplate, (String)"redisTemplate", (Object)((Object)this));
        this.setOperations = this.redisTemplate.opsForSet();
        if (this.flushOnStartup) {
            this.redisTemplate.getConnectionFactory().getConnection().flushDb();
        }
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.redisConfiguration != null) {
            this.redisConfiguration.stop();
        }
    }
}

