/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security.config;

import org.apache.camel.component.spring.security.SpringSecurityAccessPolicy;
import org.apache.camel.component.spring.security.SpringSecurityAuthorizationPolicy;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class SpringSecurityAuthorizationPolicyParser
extends BeanDefinitionParser {
    public SpringSecurityAuthorizationPolicyParser() {
        super(SpringSecurityAuthorizationPolicy.class, true);
    }

    protected boolean isEligibleAttribute(String attributeName) {
        if ("access".equals(attributeName) || "accessDecisionManager".equals(attributeName) || "authenticationManager".equals(attributeName)) {
            return false;
        }
        return super.isEligibleAttribute(attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        this.setReferenceIfAttributeDefine(builder, element, "accessDecisionManager");
        this.setReferenceIfAttributeDefine(builder, element, "authenticationManager");
        if (ObjectHelper.isNotEmpty((Object)element.getAttribute("authenticationAdapter"))) {
            builder.addPropertyReference("authenticationAdapter", element.getAttribute("authenticationAdapter"));
        }
        BeanDefinitionBuilder accessPolicyBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SpringSecurityAccessPolicy.class.getCanonicalName());
        accessPolicyBuilder.addConstructorArgValue((Object)element.getAttribute("access"));
        builder.addPropertyValue("springSecurityAccessPolicy", (Object)accessPolicyBuilder.getBeanDefinition());
    }

    protected void setReferenceIfAttributeDefine(BeanDefinitionBuilder builder, Element element, String attribute) {
        String valueRef = attribute;
        if (ObjectHelper.isNotEmpty((Object)element.getAttribute(attribute))) {
            valueRef = element.getAttribute(attribute);
        }
        builder.addPropertyReference(attribute, valueRef);
    }
}

