/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.Component;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spring.component.BeanComponent;
import org.apache.camel.spring.spi.SpringComponentResolver;
import org.apache.camel.spring.spi.SpringInjector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContext
extends DefaultCamelContext
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public SpringCamelContext() {
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext) throws Exception {
        String[] names = applicationContext.getBeanNamesForType(SpringCamelContext.class);
        if (names.length == 1) {
            return (SpringCamelContext)((Object)applicationContext.getBean(names[0], SpringCamelContext.class));
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        answer.afterPropertiesSet();
        return answer;
    }

    public static SpringCamelContext springCamelContext(String configLocations) throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)new ClassPathXmlApplicationContext(configLocations));
    }

    public void afterPropertiesSet() throws Exception {
        this.getInjector();
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.addComponent("bean", (Component)new BeanComponent(applicationContext));
    }

    protected Injector createInjector() {
        return new SpringInjector((AbstractRefreshableApplicationContext)this.getApplicationContext());
    }

    protected ComponentResolver createComponentResolver() {
        ComponentResolver defaultResolver = super.createComponentResolver();
        return new SpringComponentResolver(this.getApplicationContext(), defaultResolver);
    }
}

