/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.model.loadbalancer.LoadBalancerType;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelJMXAgentType;
import org.apache.camel.spring.CamelTemplateFactoryBean;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.spring.handler.ScriptDefinitionParser;
import org.apache.camel.spring.remoting.CamelProxyFactoryBean;
import org.apache.camel.spring.remoting.CamelServiceExporter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.ModelFileGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
extends NamespaceHandlerSupport {
    private static final transient Log LOG = LogFactory.getLog(CamelNamespaceHandler.class);
    private static final String SPRING_NS = "http://activemq.apache.org/camel/schema/spring";
    protected BeanDefinitionParser endpointParser = new BeanDefinitionParser(EndpointFactoryBean.class);
    protected BeanDefinitionParser beanPostProcessorParser = new BeanDefinitionParser(CamelBeanPostProcessor.class);
    protected Set<String> parserElementNames = new HashSet<String>();
    private JAXBContext jaxbContext;
    private Map<String, BeanDefinitionParser> parserMap = new HashMap<String, BeanDefinitionParser>();

    public static void renameNamespaceRecursive(Node node) {
        if (node.getNodeType() == 1) {
            Document doc = node.getOwnerDocument();
            if (((Element)node).getNamespaceURI().startsWith("http://activemq.apache.org/camel/schema/spring/v")) {
                doc.renameNode(node, SPRING_NS, node.getNodeName());
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            CamelNamespaceHandler.renameNamespaceRecursive(list.item(i));
        }
    }

    public ModelFileGenerator createModelFileGenerator() throws JAXBException {
        return new ModelFileGenerator(this.getJaxbContext());
    }

    public void init() {
        this.addBeanDefinitionParser("proxy", CamelProxyFactoryBean.class);
        this.addBeanDefinitionParser("template", CamelTemplateFactoryBean.class);
        this.addBeanDefinitionParser("export", CamelServiceExporter.class);
        this.addBeanDefinitionParser("jmxAgent", CamelJMXAgentType.class);
        this.registerParser("endpoint", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.endpointParser);
        boolean osgi = false;
        Class cl = CamelContextFactoryBean.class;
        try {
            cl = Class.forName("org.apache.camel.osgi.CamelContextFactoryBean");
            osgi = true;
        }
        catch (Throwable t) {
            LOG.trace((Object)("Cannot find class so assuming not running in OSGI container: " + t.getMessage()));
        }
        if (osgi) {
            LOG.info((Object)"camel-osgi.jar detected in classpath");
        } else {
            LOG.info((Object)"camel-osgi.jar not detected in classpath");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using " + cl.getCanonicalName() + " as CamelContextBeanDefinitionParser"));
        }
        this.registerParser("camelContext", (org.springframework.beans.factory.xml.BeanDefinitionParser)new CamelContextBeanDefinitionParser(cl));
    }

    private void addBeanDefinitionParser(String elementName, Class<?> type) {
        this.addBeanDefinitionParser(elementName, type, true);
    }

    private void addBeanDefinitionParser(String elementName, Class<?> type, boolean register) {
        BeanDefinitionParser parser = new BeanDefinitionParser(type);
        if (register) {
            this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)parser);
        }
        this.parserMap.put(elementName, parser);
    }

    protected void createBeanPostProcessor(ParserContext parserContext, String contextId, Element childElement, BeanDefinitionBuilder parentBuilder) {
        String beanPostProcessorId = contextId + ":beanPostProcessor";
        childElement.setAttribute("id", beanPostProcessorId);
        BeanDefinition definition = this.beanPostProcessorParser.parse(childElement, parserContext);
        definition.getPropertyValues().addPropertyValue("camelId", (Object)contextId);
        parentBuilder.addPropertyReference("beanPostProcessor", beanPostProcessorId);
    }

    protected void registerScriptParser(String elementName, String engineName) {
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)new ScriptDefinitionParser(engineName));
    }

    protected void registerParser(String name, org.springframework.beans.factory.xml.BeanDefinitionParser parser) {
        this.parserElementNames.add(name);
        this.registerBeanDefinitionParser(name, parser);
    }

    public Set<String> getParserElementNames() {
        return this.parserElementNames;
    }

    protected Object parseUsingJaxb(Element element, ParserContext parserContext, Binder<Node> binder) {
        try {
            return binder.unmarshal((Object)element);
        }
        catch (JAXBException e) {
            throw new BeanDefinitionStoreException("Failed to parse JAXB element: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = this.createJaxbContext();
        }
        return this.jaxbContext;
    }

    protected JAXBContext createJaxbContext() throws JAXBException {
        StringBuilder packages = new StringBuilder();
        for (Class cl : this.getJaxbPackages()) {
            if (packages.length() > 0) {
                packages.append(":");
            }
            packages.append(cl.getName().substring(0, cl.getName().lastIndexOf(46)));
        }
        return JAXBContext.newInstance((String)packages.toString(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    protected Set<Class> getJaxbPackages() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(CamelContextFactoryBean.class);
        classes.add(ExchangePattern.class);
        classes.add(RouteType.class);
        classes.add(StreamResequencerConfig.class);
        classes.add(DataFormatType.class);
        classes.add(ExpressionType.class);
        classes.add(LoadBalancerType.class);
        return classes;
    }

    protected void injectNamespaces(Element element, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            this.injectNamespaces(childElement, binder);
        }
    }

    protected class CamelContextBeanDefinitionParser
    extends BeanDefinitionParser {
        public CamelContextBeanDefinitionParser(Class type) {
            super(type);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            CamelNamespaceHandler.renameNamespaceRecursive(element);
            super.doParse(element, parserContext, builder);
            String contextId = element.getAttribute("id");
            if (ObjectHelper.isNullOrBlank((String)contextId)) {
                contextId = "camelContext";
                element.setAttribute("id", contextId);
            }
            Binder binder = null;
            try {
                binder = CamelNamespaceHandler.this.getJaxbContext().createBinder();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB binder :" + (Object)((Object)e), (Throwable)e);
            }
            Object value = CamelNamespaceHandler.this.parseUsingJaxb(element, parserContext, (Binder<Node>)binder);
            if (value instanceof CamelContextFactoryBean) {
                CamelContextFactoryBean factoryBean = (CamelContextFactoryBean)((Object)value);
                builder.addPropertyValue("id", (Object)contextId);
                builder.addPropertyValue("routes", factoryBean.getRoutes());
                builder.addPropertyValue("intercepts", factoryBean.getIntercepts());
                builder.addPropertyValue("dataFormats", (Object)factoryBean.getDataFormats());
                builder.addPropertyValue("builderRefs", factoryBean.getBuilderRefs());
                builder.addPropertyValue("properties", (Object)factoryBean.getProperties());
                if (factoryBean.getPackages().length > 0) {
                    builder.addPropertyValue("packages", (Object)factoryBean.getPackages());
                }
            }
            boolean createdBeanPostProcessor = false;
            NodeList list = element.getChildNodes();
            ArrayList beans = new ArrayList();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = list.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if (localName.equals("beanPostProcessor")) {
                    CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement, builder);
                    createdBeanPostProcessor = true;
                    continue;
                }
                if (localName.equals("endpoint")) {
                    BeanDefinition definition = CamelNamespaceHandler.this.endpointParser.parse(childElement, parserContext);
                    String id = childElement.getAttribute("id");
                    if (!ObjectHelper.isNotNullAndNonEmpty((String)id)) continue;
                    definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
                    parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                    continue;
                }
                BeanDefinitionParser parser = (BeanDefinitionParser)((Object)CamelNamespaceHandler.this.parserMap.get(localName));
                if (parser == null) continue;
                BeanDefinition definition = parser.parse(childElement, parserContext);
                String id = childElement.getAttribute("id");
                if (!ObjectHelper.isNotNullAndNonEmpty((String)id)) continue;
                parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                if (localName.equals("jmxAgent")) {
                    builder.addPropertyReference("camelJMXAgent", id);
                }
                if (!localName.equals("template") && !localName.equals("proxy") && !localName.equals("export")) continue;
                definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
            }
            CamelNamespaceHandler.this.injectNamespaces(element, (Binder<Node>)binder);
            if (!createdBeanPostProcessor) {
                Element childElement = element.getOwnerDocument().createElement("beanPostProcessor");
                element.appendChild(childElement);
                CamelNamespaceHandler.this.createBeanPostProcessor(parserContext, contextId, childElement, builder);
            }
        }
    }
}

