/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.spring.spi.TransactionErrorHandlerBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionPolicy
implements TransactedPolicy {
    private static final transient Log LOG = LogFactory.getLog(SpringTransactionPolicy.class);
    private TransactionTemplate template;
    private String propagationBehaviorName;
    private PlatformTransactionManager transactionManager;

    public SpringTransactionPolicy() {
    }

    public SpringTransactionPolicy(TransactionTemplate template) {
        this.template = template;
    }

    public SpringTransactionPolicy(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        ErrorHandlerBuilderRef ref;
        TransactionErrorHandler answer = new TransactionErrorHandler(this.getTransactionTemplate());
        answer.setOutput(processor);
        ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
        if (builder instanceof ErrorHandlerBuilderRef && (ref = (ErrorHandlerBuilderRef)builder).isErrorHandlerBuilderConfigued()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Looking up ErrorHandlerBuilder with ref: " + ref.getRef()));
            }
            builder = ref.lookupErrorHandlerBuilder(routeContext);
        }
        if (builder != null && builder.supportTransacted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The ErrorHandlerBuilder configured is already a TransactionErrorHandlerBuilder: " + builder));
            }
            answer.setExceptionPolicy(builder.getExceptionPolicyStrategy());
            builder.configure((ErrorHandler)answer);
        } else {
            if (LOG.isDebugEnabled()) {
                if (builder != null) {
                    LOG.debug((Object)("The ErrorHandlerBuilder configured is not a TransactionErrorHandlerBuilder: " + builder));
                } else {
                    LOG.debug((Object)"No ErrorHandlerBuilder configured, will use default TransactionErrorHandlerBuilder settings");
                }
            }
            TransactionErrorHandlerBuilder txBuilder = new TransactionErrorHandlerBuilder();
            txBuilder.setTransactionTemplate(this.getTransactionTemplate());
            txBuilder.setSpringTransactionPolicy(this);
            if (builder != null) {
                txBuilder.setErrorHandlers(builder.getErrorHandlers());
            }
            answer.setExceptionPolicy(txBuilder.getExceptionPolicyStrategy());
            txBuilder.configure((ErrorHandler)answer);
            routeContext.getRoute().setErrorHandlerBuilder((ErrorHandlerBuilder)txBuilder);
        }
        return answer;
    }

    public TransactionTemplate getTransactionTemplate() {
        if (this.template == null) {
            ObjectHelper.notNull((Object)this.transactionManager, (String)"transactionManager");
            this.template = new TransactionTemplate(this.transactionManager);
            if (this.propagationBehaviorName != null) {
                this.template.setPropagationBehaviorName(this.propagationBehaviorName);
            }
        }
        return this.template;
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setPropagationBehaviorName(String propagationBehaviorName) {
        this.propagationBehaviorName = propagationBehaviorName;
    }

    public String getPropagationBehaviorName() {
        return this.propagationBehaviorName;
    }
}

